/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.PackageDefinition;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleErrorInformationReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.ErrorDescriptor;
import workbench.util.CollectionUtil;

public class OracleObjectCompiler {
    private WbConnection dbConnection;
    private OracleErrorInformationReader errorReader;
    private static final Set<String> COMPILABLE_TYPES = CollectionUtil.caseInsensitiveSet("VIEW", "MATERIALIZED VIEW", "PROCEDURE", "FUNCTION", "PACKAGE", "TRIGGER", "TYPE");

    public OracleObjectCompiler(WbConnection wbConnection) throws SQLException {
        this.dbConnection = wbConnection;
        this.errorReader = new OracleErrorInformationReader(this.dbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compileObject(DbObject dbObject) {
        String string;
        String string2 = this.createCompileStatement(dbObject);
        if (Settings.getInstance().getLogAllStatements()) {
            LogMgr.logInfo(new CallerInfo(){}, "Compiling " + dbObject.getObjectType() + " " + dbObject.getObjectName() + " using: " + string2);
        }
        Statement statement = null;
        try {
            statement = this.dbConnection.createStatement();
            this.dbConnection.setBusy(true);
            statement.executeUpdate(string2);
            String string3 = dbObject.getObjectType();
            string = dbObject.getObjectName();
            if (dbObject instanceof ProcedureDefinition && ((ProcedureDefinition)dbObject).isPackageProcedure()) {
                string3 = "PACKAGE BODY";
                string = dbObject.getCatalog();
            } else if (dbObject instanceof PackageDefinition) {
                string3 = "PACKAGE BODY";
            }
            ErrorDescriptor errorDescriptor = this.errorReader.getErrorInfo(null, null, string, string3, false);
            if (errorDescriptor == null) {
                String string4 = null;
                return string4;
            }
            String string5 = errorDescriptor.getErrorMessage();
            return string5;
        }
        catch (SQLException sQLException) {
            string = sQLException.getMessage();
            return string;
        }
        finally {
            JdbcUtils.closeStatement(statement);
            this.dbConnection.setBusy(false);
        }
    }

    String createCompileStatement(DbObject dbObject) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("ALTER ");
        if (dbObject instanceof ProcedureDefinition && ((ProcedureDefinition)dbObject).isPackageProcedure()) {
            ProcedureDefinition procedureDefinition = (ProcedureDefinition)dbObject;
            stringBuilder.append("PACKAGE ");
            stringBuilder.append(this.dbConnection.getMetadata().quoteObjectname(procedureDefinition.getSchema()));
            stringBuilder.append('.');
            stringBuilder.append(this.dbConnection.getMetadata().quoteObjectname(procedureDefinition.getPackageName()));
        } else if (dbObject instanceof PackageDefinition) {
            PackageDefinition packageDefinition = (PackageDefinition)dbObject;
            stringBuilder.append("PACKAGE ");
            stringBuilder.append(packageDefinition.getFullyQualifiedName(this.dbConnection));
        } else {
            stringBuilder.append(dbObject.getObjectType());
            stringBuilder.append(' ');
            stringBuilder.append(dbObject.getFullyQualifiedName(this.dbConnection));
        }
        stringBuilder.append(" COMPILE");
        return stringBuilder.toString();
    }

    public static boolean canCompile(DbObject dbObject) {
        if (dbObject == null) {
            return false;
        }
        String string = dbObject.getObjectType();
        return COMPILABLE_TYPES.contains(string);
    }
}

