/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.PartitionLister;
import workbench.db.SubPartitionState;
import workbench.db.TableIdentifier;
import workbench.db.TablePartition;
import workbench.db.WbConnection;
import workbench.db.oracle.OraclePartitionDefinition;
import workbench.db.oracle.OracleTablePartition;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;

public class OraclePartitionLister
extends OracleTablePartition
implements PartitionLister {
    private final WbConnection conn;

    public OraclePartitionLister(WbConnection wbConnection) {
        super(wbConnection, true);
        this.conn = wbConnection;
    }

    public List<TablePartition> getPartitions(TableIdentifier tableIdentifier) {
        ArrayList<TablePartition> arrayList = new ArrayList<TablePartition>();
        try {
            boolean bl = super.retrieveDefinition(tableIdentifier, this.conn);
            if (!bl) {
                return null;
            }
            SubPartitionState subPartitionState = SubPartitionState.unknown;
            if (!this.hasSubPartitions()) {
                subPartitionState = SubPartitionState.none;
            }
            List<OraclePartitionDefinition> list = super.loadPartitions(tableIdentifier, this.conn);
            for (OraclePartitionDefinition oraclePartitionDefinition : list) {
                TablePartition tablePartition = new TablePartition();
                CharSequence charSequence = oraclePartitionDefinition.getSource(true, 0, "");
                if (charSequence != null) {
                    tablePartition.setDefinition(charSequence.toString());
                }
                tablePartition.setSubPartitionStrategy(oraclePartitionDefinition.getSubPartitionType());
                tablePartition.setSchema(tableIdentifier.getRawSchema());
                tablePartition.setName(oraclePartitionDefinition.getName());
                tablePartition.setPartitionStrategy(oraclePartitionDefinition.getType());
                tablePartition.setSubPartitionState(subPartitionState);
                arrayList.add(tablePartition);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not load partitions", sQLException);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TablePartition> getSubPartitions(TableIdentifier tableIdentifier, TablePartition tablePartition) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "-- SQL Workbench \nselect sub.subpartition_name, sub.high_value, sub.subpartition_position, tbl.subpartitioning_type \nfrom all_tab_subpartitions sub \n  join all_part_tables tbl on tbl.owner = sub.table_owner and tbl.table_name = sub.table_name \nwhere sub.table_owner = ? \n  and sub.table_name = ? \n  and sub.partition_name = ? \norder by sub.subpartition_position";
        ArrayList<TablePartition> arrayList = new ArrayList<TablePartition>();
        String string2 = SqlUtil.removeObjectQuotes(tablePartition.getObjectName());
        long l = System.currentTimeMillis();
        try {
            preparedStatement = this.conn.getSqlConnection().prepareStatement(string);
            LogMgr.logMetadataSql(new CallerInfo(){}, "sub-partitions", string, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName(), string2);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            preparedStatement.setString(3, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString("subpartition_name");
                String string4 = resultSet.getString("high_value");
                int n = resultSet.getInt("subpartition_position");
                String string5 = resultSet.getString("subpartitioning_type");
                OraclePartitionDefinition oraclePartitionDefinition = new OraclePartitionDefinition(string3, string5, n);
                oraclePartitionDefinition.setIsSubpartition(true);
                oraclePartitionDefinition.setPartitionValue(string4);
                CharSequence charSequence = oraclePartitionDefinition.getSource(true, 0, "");
                TablePartition tablePartition2 = new TablePartition();
                if (charSequence != null) {
                    tablePartition2.setDefinition(charSequence.toString());
                }
                tablePartition2.setIsSubPartition(true);
                tablePartition2.setPartitionStrategy(string5);
                tablePartition2.setName(string3);
                tablePartition2.setSchema(tableIdentifier.getRawSchema());
                arrayList.add(tablePartition2);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "sub-partitions", string, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName(), string2);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving sub partitions " + tableIdentifier.getObjectName() + " took: " + l2 + "ms");
        return arrayList;
    }

    @Override
    public boolean supportsSubPartitions() {
        return true;
    }
}

