/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.StatementHook;
import workbench.sql.StatementRunner;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.sql.wbcommands.CommandTester;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OracleStatementHook
implements StatementHook {
    private static final String RETRIEVE_STATS = "-- SQL Workbench \n select a.name, coalesce(s.value,0) as value, s.statistic# \nfrom v$sesstat s \n  join v$statname a on a.statistic# = s.statistic# \nwhere sid = userenv('SID') \nand a.name in";
    public static final List<String> DEFAULT_STAT_NAMES = CollectionUtil.arrayList("recursive calls", "db block gets", "consistent gets", "physical reads", "redo size", "bytes sent via SQL*Net to client", "bytes received via SQL*Net from client", "SQL*Net roundtrips to/from client", "sorts (memory)", "sorts (disk)\n, db block changes, \n consistent gets from cache", "consistent gets from cache (fastpath)", "logical read bytes from cache, \n Requests to/from client", "session logical reads");
    private static final String DEFAULT_STATS = StringUtil.listToString(DEFAULT_STAT_NAMES, ",", true, '\'');
    private static final Set<String> EXPLAINABLE = CollectionUtil.caseInsensitiveSet("SELECT", "INSERT", "UPDATE", "DELETE", "CREATE", "ALTER");
    private final Set<String> noStatistics = CollectionUtil.caseInsensitiveSet("SET", "COMMIT", "ROLLBACK", "SET", "SHOW", "EXPLAIN");
    private Map<String, Long> values;
    private boolean statisticViewsAvailable;
    private boolean autotrace;
    private boolean traceOnly;
    private boolean showExecutionPlan;
    private boolean showRealPlan;
    private boolean showStatistics;
    private String lastExplainID;
    private String lastStatisticsLevel;
    private PreparedStatement statisticsStmt;
    private final Object lock = new Object();
    private CommandTester wbTester = new CommandTester();
    private final SQLLexer lexer = SQLLexerFactory.createLexer(ParserType.Oracle, (CharSequence)"");

    @Override
    public String preExec(StatementRunner statementRunner, String string) {
        if (!this.autotrace || !this.shouldTraceStatement(string)) {
            return string;
        }
        this.lastExplainID = null;
        if (this.showStatistics) {
            this.storeSessionStats(statementRunner);
        }
        if (this.showRealPlan) {
            string = this.adjustSql(string);
            LogMgr.logDebug(new CallerInfo(){}, "Using modified SQL to display the real execution plan:\n" + string);
        }
        return string;
    }

    private boolean useStatisticsHint() {
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.realplan.usehint", true);
    }

    private boolean alwaysUsePrefix() {
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.realplan.always.inject.id", true);
    }

    @Override
    public boolean isPending() {
        return this.autotrace;
    }

    @Override
    public void postExec(StatementRunner statementRunner, String string, StatementRunnerResult statementRunnerResult) {
        DataStore dataStore;
        this.checkRunnerSession(statementRunner, string);
        if (!this.autotrace || !this.shouldTraceStatement(string)) {
            return;
        }
        if (this.showStatistics) {
            if (!this.statisticViewsAvailable) {
                statementRunnerResult.addWarningByKey("ErrNoAutoTrace");
            } else {
                dataStore = this.retrieveStatistics(statementRunner, string);
                if (dataStore != null) {
                    int n = this.getValueColIndex();
                    int n2 = this.getNameColIndex();
                    long l = statementRunnerResult.getRowsProcessed();
                    int n3 = dataStore.addRow();
                    dataStore.setValue(n3, n2, (Object)"rows processed");
                    dataStore.setValue(n3, n, (Object)l);
                    dataStore.setGeneratingSql(string);
                    dataStore.resetStatus();
                    statementRunnerResult.addDataStore(dataStore);
                }
            }
        }
        dataStore = null;
        if (this.showRealPlan) {
            dataStore = this.retrieveRealExecutionPlan(statementRunner, string);
        }
        if (this.showExecutionPlan && dataStore == null) {
            dataStore = this.retrieveExecutionPlan(statementRunner, string);
        }
        if (dataStore != null) {
            statementRunnerResult.addDataStore(dataStore);
        }
    }

    private String adjustSql(String string) {
        this.lastExplainID = UUID.randomUUID().toString();
        if (this.useStatisticsHint()) {
            string = this.injectHint(string);
        }
        if (this.showStatistics || this.alwaysUsePrefix()) {
            return this.getIDPrefix() + "\n" + string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String injectHint(String string) {
        boolean bl = false;
        int n = -1;
        SQLToken sQLToken = null;
        SQLToken sQLToken2 = null;
        Object object = this.lexer;
        synchronized (object) {
            this.lexer.setInput(string);
            sQLToken = this.lexer.getNextToken(false, false);
            if (sQLToken == null) {
                return this.getIDPrefix() + "  " + string;
            }
            if ("with".equalsIgnoreCase(sQLToken.getContents())) {
                sQLToken = SqlUtil.skipCTE(this.lexer);
            }
            sQLToken2 = this.lexer.getNextToken(true, false);
        }
        if (sQLToken2 == null) {
            return this.getIDPrefix() + "  " + string;
        }
        bl = true;
        if (sQLToken2.isComment() && ((String)(object = sQLToken2.getContents())).startsWith("/*+")) {
            bl = false;
            n = sQLToken2.getCharBegin();
        }
        if (n < 0) {
            n = sQLToken.getCharEnd();
        }
        if (n < 0) {
            return string;
        }
        if (bl) {
            string = string.substring(0, n) + " /*+ gather_plan_statistics */ " + string.substring(n + 1);
        } else if (string.indexOf("gather_plan_statistics", n) < 0) {
            string = string.substring(0, n + 3) + " gather_plan_statistics " + string.substring(n + 3);
        }
        return string;
    }

    private String getIDPrefix() {
        if (this.lastExplainID == null) {
            return "";
        }
        return "-- wb$" + this.lastExplainID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSessionStats(StatementRunner statementRunner) {
        WbConnection wbConnection = statementRunner.getConnection();
        this.values = new HashMap<String, Long>(10);
        ResultSet resultSet = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                this.prepareStatisticsStatement(wbConnection);
                resultSet = this.statisticsStmt.executeQuery();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    Long l = resultSet.getLong(2);
                    this.values.put(string, l);
                }
                this.statisticViewsAvailable = true;
            }
        }
        catch (SQLException sQLException) {
            try {
                if (sQLException.getErrorCode() == 942) {
                    this.statisticViewsAvailable = false;
                }
                LogMgr.logError(new CallerInfo(){}, "Could not retrieve session statistics", sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResult(resultSet);
                throw throwable;
            }
            JdbcUtils.closeResult(resultSet);
        }
        JdbcUtils.closeResult(resultSet);
    }

    private String buildStatisticsQuery() {
        String string = Settings.getInstance().getProperty("workbench.db.oracle.autotrace.statname", DEFAULT_STATS);
        return "-- SQL Workbench \n select a.name, coalesce(s.value,0) as value, s.statistic# \nfrom v$sesstat s \n  join v$statname a on a.statistic# = s.statistic# \nwhere sid = userenv('SID') \nand a.name in (" + string + ") \n ORDER BY lower(a.name)";
    }

    private boolean showStatvalueFirst() {
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.autotrace.statistics.valuefirst", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldTraceStatement(String string) {
        SQLLexer sQLLexer = this.lexer;
        synchronized (sQLLexer) {
            this.lexer.setInput(string);
            SQLToken sQLToken = this.lexer.getNextToken(false, false);
            if (sQLToken == null) {
                return false;
            }
            String string2 = sQLToken.getContents();
            return !this.noStatistics.contains(string2);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore retrieveRealExecutionPlan(StatementRunner statementRunner, String string) {
        DataStore dataStore;
        block11: {
            WbConnection wbConnection = statementRunner.getConnection();
            PreparedStatement preparedStatement = null;
            Statement statement = null;
            ResultSet resultSet = null;
            dataStore = null;
            String string2 = "PARTITION ALIAS BYTES COST NOTE ROWS ALLSTATS LAST";
            String string3 = Settings.getInstance().getProperty("workbench.db.oracle.xplan.options", string2);
            if (StringUtil.isEmptyString(string3)) {
                string3 = string2;
            }
            CallerInfo callerInfo = new CallerInfo(){};
            boolean bl = false;
            try {
                String string4;
                if ((this.alwaysUsePrefix() || this.showStatistics) && this.lastExplainID != null) {
                    string4 = "SELECT * FROM table(dbms_xplan.display_cursor(?, ?, ?))";
                    bl = true;
                } else {
                    string4 = "SELECT * FROM table(dbms_xplan.display_cursor(format => ?))";
                    bl = false;
                }
                preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
                statement = wbConnection.createStatementForQuery();
                if (bl) {
                    String string5 = "-- SQL Workbench \n select sql.sql_id, sql.child_number \nfrom v$sql sql \nwhere sql_text like '" + this.getIDPrefix() + "%' \norder by last_active_time desc";
                    LogMgr.logDebug(callerInfo, "SQL to find last explained statement: \n" + string5);
                    resultSet = statement.executeQuery(string5);
                    if (resultSet.next()) {
                        String string6 = resultSet.getString(1);
                        int n = resultSet.getInt(2);
                        preparedStatement.setString(1, string6);
                        preparedStatement.setInt(2, n);
                        preparedStatement.setString(3, string3);
                        JdbcUtils.closeResult(resultSet);
                        LogMgr.logDebug(callerInfo, "Getting plan for sqlid=" + string6 + ", child=" + n + " using:\n" + SqlUtil.replaceParameters(string4, string6, n, string3));
                    }
                } else {
                    preparedStatement.setString(1, string3);
                    LogMgr.logDebug(callerInfo, "Retrieving execution plan for last SQL using:\n" + SqlUtil.replaceParameters(string4, string3));
                }
                resultSet = preparedStatement.executeQuery();
                dataStore = new DataStore(resultSet, true);
                dataStore.setGeneratingSql(string);
                dataStore.setResultName("Execution plan");
                dataStore.resetStatus();
                JdbcUtils.closeStatement(preparedStatement);
            }
            catch (SQLException sQLException) {
                LogMgr.logError(callerInfo, "Could not retrieve real execution plan", sQLException);
                break block11;
            }
            finally {
                JdbcUtils.closeStatement(preparedStatement);
                JdbcUtils.closeAll(resultSet, statement);
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStatisticsLevel(WbConnection wbConnection, String string) {
        CallerInfo callerInfo = new CallerInfo(){};
        Statement statement = null;
        try {
            if (StringUtil.isEmptyString(string)) {
                string = "TYPICAL";
            }
            LogMgr.logInfo(callerInfo, "Setting STATISTICS_LEVEL to " + string);
            statement = wbConnection.createStatement();
            statement.execute("alter session set statistics_level=" + string);
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logError(callerInfo, "Could not enable statistics level: " + string, sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
            JdbcUtils.closeStatement(statement);
        }
        JdbcUtils.closeStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore retrieveExecutionPlan(StatementRunner statementRunner, String string) {
        if (!this.canExplain(string)) {
            return null;
        }
        WbConnection wbConnection = statementRunner.getConnection();
        CallerInfo callerInfo = new CallerInfo(){};
        String string2 = "EXPLAIN PLAN FOR " + string;
        String string3 = "SELECT * FROM TABLE(DBMS_XPLAN.DISPLAY(format => 'TYPICAL ALIAS PROJECTION'))";
        LogMgr.logDebug(callerInfo, "Running EXPLAIN PLAN for last SQL statement");
        Statement statement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        try {
            statement = wbConnection.createStatementForQuery();
            statement.execute(string2);
            resultSet = statement.executeQuery(string3);
            dataStore = new DataStore(resultSet, true);
            dataStore.setGeneratingSql(string);
            dataStore.setResultName("Execution plan");
            dataStore.resetStatus();
            JdbcUtils.closeAll(resultSet, statement);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(callerInfo, "Could not retrieve session statistics", sQLException);
        }
        finally {
            JdbcUtils.closeAll(resultSet, statement);
        }
        return dataStore;
    }

    private int getNameColIndex() {
        return this.showStatvalueFirst() ? 1 : 0;
    }

    private int getValueColIndex() {
        return this.showStatvalueFirst() ? 0 : 1;
    }

    private void prepareStatisticsStatement(WbConnection wbConnection) throws SQLException {
        if (this.statisticsStmt == null) {
            this.statisticsStmt = wbConnection.getSqlConnection().prepareStatement(this.buildStatisticsQuery());
        }
    }

    private boolean skipStatistics(String string) {
        if (this.wbTester.isWbCommand(string)) {
            return true;
        }
        return this.noStatistics.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore retrieveStatistics(StatementRunner statementRunner, String string) {
        WbConnection wbConnection = statementRunner.getConnection();
        if (wbConnection == null) {
            return null;
        }
        String string2 = wbConnection.getParsingUtil().getSqlVerb(string);
        if (this.skipStatistics(string2)) {
            return null;
        }
        ResultSet resultSet = null;
        DataStore dataStore = this.createResult();
        int n = this.getValueColIndex();
        int n2 = this.getNameColIndex();
        try {
            Object object = this.lock;
            synchronized (object) {
                this.prepareStatisticsStatement(wbConnection);
                resultSet = this.statisticsStmt.executeQuery();
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    Long l = resultSet.getLong(2);
                    Long l2 = this.nvl(this.values.get(string3));
                    int n3 = dataStore.addRow();
                    dataStore.setValue(n3, n2, (Object)string3);
                    dataStore.setValue(n3, n, (Object)(l - l2));
                }
            }
            dataStore.setResultName("Statistics");
            JdbcUtils.closeResult(resultSet);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve session statistics", sQLException);
        }
        finally {
            JdbcUtils.closeResult(resultSet);
        }
        return dataStore;
    }

    private Long nvl(Long l) {
        if (l != null) {
            return l;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canExplain(String string) {
        SQLLexer sQLLexer = this.lexer;
        synchronized (sQLLexer) {
            this.lexer.setInput(string);
            SQLToken sQLToken = this.lexer.getNextToken(false, false);
            if (sQLToken == null) {
                return false;
            }
            if (!EXPLAINABLE.contains(sQLToken.getContents())) {
                return false;
            }
            String string2 = sQLToken.getContents();
            if ("CREATE".equalsIgnoreCase(string2)) {
                SQLToken sQLToken2 = this.lexer.getNextToken(false, false);
                if (sQLToken2 == null) {
                    return false;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 7] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                String string3 = sQLToken2.getContents();
                return string3.equalsIgnoreCase("TABLE") || string3.equalsIgnoreCase("INDEX");
            }
            if ("ALTER".equalsIgnoreCase(string2)) {
                SQLToken sQLToken3 = this.lexer.getNextToken(false, false);
                if (sQLToken3 == null) {
                    return false;
                }
                sQLToken3 = this.lexer.getNextToken(false, false);
                if (sQLToken3 == null) {
                    return false;
                }
                return "REBUILD".equalsIgnoreCase(sQLToken3.getContents());
            }
            return true;
        }
    }

    @Override
    public boolean displayResults() {
        if (!this.autotrace) {
            return true;
        }
        return !this.traceOnly;
    }

    @Override
    public boolean fetchResults() {
        if (!this.autotrace) {
            return true;
        }
        if (this.traceOnly) {
            return this.showStatistics || this.showRealPlan;
        }
        return true;
    }

    private void checkRunnerSession(StatementRunner statementRunner, String string) {
        String string2 = statementRunner.getSessionAttribute("autotrace");
        if (string2 == null) {
            if (this.autotrace) {
                this.close(statementRunner.getConnection());
            }
            this.autotrace = false;
            return;
        }
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(StringUtil.stringToList(string2, ",", true, true, false, false));
        this.traceOnly = set.contains("traceonly");
        this.autotrace = set.contains("on") || this.traceOnly;
        this.showExecutionPlan = set.contains("explain") || this.autotrace && set.size() == 1;
        this.showStatistics = set.contains("statistics") || this.autotrace && set.size() == 1;
        boolean bl = this.showRealPlan = this.autotrace && set.contains("realplan");
        if (this.showRealPlan) {
            this.showExecutionPlan = this.showRealPlan;
            String string3 = statementRunner.getConnection().getParsingUtil().getSqlVerb(string);
            if (!this.useStatisticsHint() && StringUtil.equalStringIgnoreCase("SET", string3)) {
                if (this.lastStatisticsLevel == null) {
                    this.lastStatisticsLevel = this.retrieveStatisticsLevel(statementRunner.getConnection());
                }
                this.changeStatisticsLevel(statementRunner.getConnection(), "ALL");
            }
        }
    }

    private DataStore createResult() {
        DataStore dataStore = null;
        if (this.showStatvalueFirst()) {
            String[] stringArray = new String[]{"VALUE", "STATISTIC"};
            int[] nArray = new int[]{-5, 12};
            dataStore = new DataStore(stringArray, nArray);
        } else {
            String[] stringArray = new String[]{"STATISTIC", "VALUE"};
            int[] nArray = new int[]{12, -5};
            dataStore = new DataStore(stringArray, nArray);
        }
        return dataStore;
    }

    @Override
    public void close(WbConnection wbConnection) {
        JdbcUtils.closeStatement(this.statisticsStmt);
        this.statisticsStmt = null;
        this.lastExplainID = null;
        if (this.lastStatisticsLevel != null && wbConnection != null) {
            this.changeStatisticsLevel(wbConnection, this.lastStatisticsLevel);
            this.lastStatisticsLevel = null;
        }
    }

    private String retrieveStatisticsLevel(WbConnection wbConnection) {
        CallableStatement callableStatement = null;
        String string = null;
        String string2 = "{? = call dbms_utility.get_parameter_value('STATISTICS_LEVEL', ?, ?)}";
        CallerInfo callerInfo = new CallerInfo(){};
        if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logDebug(callerInfo, "Retrieving statistics level using:\n" + string2);
        }
        try {
            callableStatement = wbConnection.getSqlConnection().prepareCall(string2);
            callableStatement.registerOutParameter(1, 4);
            callableStatement.registerOutParameter(2, 4);
            callableStatement.registerOutParameter(3, 12);
            callableStatement.execute();
            string = callableStatement.getString(3);
            LogMgr.logDebug(callerInfo, "Current level: " + string);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(callerInfo, "Could not retrieve STATISTICS_LEVEL", sQLException);
        }
        return string;
    }
}

