/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import workbench.db.ConnectionProfile;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OracleUtils {
    public static final String PROP_KEY_TBLSPACE = "oracle_default_tablespace";
    public static final String PROP_FIX_TIMESTAMPTZ = "workbench.db.oracle.fix.timstamptz";
    public static final String PROP_FIX_PLSQL_RESULTSET = "workbench.db.oracle.fix.plsql.resultset";
    public static final String KEYWORD_EDITIONABLE = "EDITIONABLE";
    public static final Set<String> STANDARD_TYPES = CollectionUtil.caseInsensitiveSet("INTERVALDS", "INTERVALYM", "TIMESTAMP WITH LOCAL TIME ZONE", "TIMESTAMP WITH TIME ZONE", "NUMBER", "NUMBER", "NUMBER", "LONG RAW", "RAW", "LONG", "CHAR", "NUMBER", "NUMBER", "NUMBER", "FLOAT", "REAL", "VARCHAR2", "DATE", "DATE", "TIMESTAMP", "STRUCT", "ARRAY", "BLOB", "CLOB", "ROWID", "XMLType", "SDO_GEOMETRY", "SDO_TOPO_GEOMETRY", "SDO_GEORASTER", "ANYTYPE", "ANYDATA");

    private OracleUtils() {
    }

    static boolean getRemarksReporting(WbConnection wbConnection) {
        String string = OracleUtils.getDriverProperty(wbConnection, "remarksReporting", false);
        if (string == null) {
            string = OracleUtils.getDriverProperty(wbConnection, "oracle.jdbc.remarksReporting", true);
        }
        return StringUtil.stringToBool(string);
    }

    static boolean getMapDateToTimestamp(WbConnection wbConnection) {
        if (Settings.getInstance().fixOracleDateType()) {
            return true;
        }
        String string = OracleUtils.getDriverProperty(wbConnection, "oracle.jdbc.mapDateToTimestamp", true);
        if (string == null) {
            return true;
        }
        return StringUtil.stringToBool(string);
    }

    static String getDriverProperty(WbConnection wbConnection, String string, boolean bl) {
        if (wbConnection == null) {
            return "false";
        }
        String string2 = null;
        ConnectionProfile connectionProfile = wbConnection.getProfile();
        if (connectionProfile != null) {
            Properties properties = connectionProfile.getConnectionProperties();
            String string3 = string2 = properties != null ? properties.getProperty(string, null) : null;
            if (string2 == null && bl) {
                string2 = System.getProperty(string, null);
            }
        }
        return string2;
    }

    public static boolean remarksEnabled(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        ConnectionProfile connectionProfile = wbConnection.getProfile();
        Properties properties = connectionProfile.getConnectionProperties();
        String string = "false";
        if (properties != null) {
            string = properties.getProperty("remarksReporting", "false");
        }
        return StringUtil.stringToBool(string);
    }

    public static boolean supportsPartitioning(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (!wbConnection.getMetadata().isOracle()) {
            return false;
        }
        String string = wbConnection.getDatabaseProductVersion();
        if (StringUtil.isBlank(string)) {
            return false;
        }
        return !string.toLowerCase().contains("express edition");
    }

    public static boolean remarksEnabledMySQL(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        ConnectionProfile connectionProfile = wbConnection.getProfile();
        Properties properties = connectionProfile.getConnectionProperties();
        String string = "false";
        if (properties != null) {
            string = properties.getProperty("useInformationSchema", "false");
        }
        return StringUtil.stringToBool(string);
    }

    public static boolean isCommonUser(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        String string = wbConnection.getCurrentUser();
        if (StringUtil.isBlank(string)) {
            return false;
        }
        boolean bl = wbConnection.getProfile().getOracleSysDBA();
        return string.toLowerCase().equals("sys") || bl || string.toLowerCase().startsWith("c##");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMultipleContainers(WbConnection wbConnection) {
        ResultSet resultSet;
        Statement statement;
        int n;
        block5: {
            if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "12.1")) {
                return false;
            }
            n = 0;
            statement = null;
            resultSet = null;
            try {
                statement = wbConnection.createStatementForQuery();
                resultSet = statement.executeQuery("select count(*) from v$pdbs");
                if (!resultSet.next()) break block5;
                n = resultSet.getInt(1);
            }
            catch (Exception exception) {
                try {
                    n = 0;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return n > 0;
    }

    public static String getCurrentContainer(WbConnection wbConnection) {
        String string = "-- SQL Workbench \nselect sys_context('userenv', 'CON_NAME') from dual";
        LogMgr.logMetadataSql(new CallerInfo(){}, "current container", string, new Object[0]);
        return OracleUtils.getSingleResult(string, wbConnection);
    }

    public static String getDefaultTablespace(WbConnection wbConnection) {
        if (wbConnection == null) {
            return "";
        }
        OracleUtils.readDefaultTableSpace(wbConnection);
        return wbConnection.getSessionProperty(PROP_KEY_TBLSPACE);
    }

    private static synchronized void readDefaultTableSpace(WbConnection wbConnection) {
        if (wbConnection.getSessionProperty(PROP_KEY_TBLSPACE) != null) {
            return;
        }
        String string = "-- SQL Workbench \nselect default_tablespace \nfrom user_users";
        LogMgr.logMetadataSql(new CallerInfo(){}, "default tablespace", string, new Object[0]);
        String string2 = OracleUtils.getSingleResult(string, wbConnection);
        wbConnection.setSessionProperty(PROP_KEY_TBLSPACE, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSingleResult(String string, WbConnection wbConnection) {
        String string2;
        ResultSet resultSet;
        Statement statement;
        block4: {
            statement = null;
            resultSet = null;
            string2 = null;
            try {
                statement = wbConnection.createStatementForQuery();
                resultSet = statement.executeQuery(string);
                if (!resultSet.next()) break block4;
                string2 = resultSet.getString(1);
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logError(new CallerInfo(){}, "Error running query:\n" + string, sQLException);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return string2;
    }

    public static String getCacheHint() {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.oracle.metadata.result_cache", false);
        return bl ? "/*+ result_cache */ " : "";
    }

    public static boolean checkDefaultTablespace() {
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.check_default_tablespace", false);
    }

    public static boolean retrieveTablespaceInfo() {
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.retrieve_tablespace", true);
    }

    public static boolean showSystemGeneratedExtendedStats() {
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.extended_stats.include.system", false);
    }

    public static boolean shouldAppendTablespace(String string, String string2, String string3, String string4) {
        if (StringUtil.isBlank(string)) {
            return false;
        }
        if (!StringUtil.equalStringIgnoreCase(StringUtil.trimQuotes(string3), string4)) {
            return true;
        }
        if (!OracleUtils.retrieveTablespaceInfo()) {
            return false;
        }
        if (StringUtil.isBlank(string2)) {
            return true;
        }
        return !string.equals(string2);
    }

    public static String trimSQLPlusLineContinuation(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        List<String> list = StringUtil.getLines(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (String string2 : list) {
            String string3 = StringUtil.rtrim(string2);
            if (string3.endsWith("-")) {
                stringBuilder.append(string3.substring(0, string3.length() - 1));
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static boolean shouldTrimContinuationCharacter(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (wbConnection.getMetadata().isOracle()) {
            return Settings.getInstance().getBoolProperty("workbench.db.oracle.trim.sqlplus.continuation", false);
        }
        return false;
    }

    public static boolean optimizeCatalogQueries() {
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.prefer_user_catalog_tables", true);
    }

    public static boolean showSetServeroutputFeedback() {
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.set_serveroutput.feedback", false);
    }

    public static boolean is12_1_0_2(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "12.1")) {
            return false;
        }
        try {
            String string = wbConnection.getSqlConnection().getMetaData().getDatabaseProductVersion();
            return OracleUtils.is12_1_0_2(string);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean is12_1_0_2(String string) {
        int n = string.indexOf("Release ");
        if (n < 0) {
            return false;
        }
        int n2 = string.indexOf(" - ", n);
        String string2 = string.substring(n + "Release".length() + 1, n2);
        if (!string2.startsWith("12")) {
            return false;
        }
        String[] stringArray = string2.split("\\.");
        if (stringArray == null || stringArray.length < 5) {
            return false;
        }
        try {
            int n3 = Integer.parseInt(stringArray[0]);
            int n4 = Integer.parseInt(stringArray[1]);
            int n5 = Integer.parseInt(stringArray[2]);
            int n6 = Integer.parseInt(stringArray[3]);
            if (n3 < 12) {
                return false;
            }
            if (n4 > 1) {
                return true;
            }
            return n5 >= 0 && n6 >= 2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean cleanupDDLQuotedIdentifiers() {
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.dbmsmeta.cleanup.quotes", false);
    }

    public static boolean getUseOracleDBMSMeta(DbmsMetadataTypes dbmsMetadataTypes) {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.oracle.use.dbmsmeta", false);
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.use.dbmsmeta." + dbmsMetadataTypes.name(), bl);
    }

    public static void setUseOracleDBMSMeta(DbmsMetadataTypes dbmsMetadataTypes, boolean bl) {
        Settings.getInstance().setProperty("workbench.db.oracle.use.dbmsmeta." + dbmsMetadataTypes.name(), bl);
    }

    public static boolean showContainerInfo() {
        return Settings.getInstance().getBoolProperty("workbench.db.oracle.conninfo.include.container", false);
    }

    public static boolean fixPLSQLResultSetBug() {
        return Settings.getInstance().getBoolProperty(PROP_FIX_PLSQL_RESULTSET, true);
    }

    public static String[] adjustTableTypes(WbConnection wbConnection, String[] stringArray) {
        if (DbMetadata.typeIncluded("TABLE", stringArray) && DbMetadata.typeIncluded("MATERIALIZED VIEW", stringArray)) {
            stringArray = CollectionUtil.removeElement(stringArray, "MATERIALIZED VIEW");
        } else if (DbMetadata.typeIncluded("MATERIALIZED VIEW", stringArray) && JdbcUtils.hasMiniumDriverVersion(wbConnection, "12.1")) {
            CollectionUtil.replaceElement(stringArray, "MATERIALIZED VIEW", "TABLE");
        }
        return stringArray;
    }

    public static DataStore getPDBs(WbConnection wbConnection) throws SQLException {
        return SqlUtil.getResultData(wbConnection, "select con_id, name, open_mode, restricted \nfrom gv$pdbs", false);
    }

    public static enum DbmsMetadataTypes {
        procedure,
        trigger,
        index,
        table,
        mview,
        view,
        sequence,
        synonym,
        grant,
        constraint;

    }
}

