/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import workbench.db.TableIdentifier;
import workbench.db.ViewGrantReader;
import workbench.db.WbConnection;
import workbench.db.oracle.DbmsMetadata;
import workbench.db.oracle.OracleUtils;

public class OracleViewGrantReader
extends ViewGrantReader {
    @Override
    public String getViewGrantSql() {
        return "-- SQL Workbench \nSELECT grantee, privilege, grantable \nFROM all_tab_privs \nWHERE table_name = ? \n  AND table_schema = ? ";
    }

    @Override
    public int getIndexForTableNameParameter() {
        return 1;
    }

    @Override
    public int getIndexForSchemaParameter() {
        return 2;
    }

    @Override
    public StringBuilder getViewGrantSource(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.grant)) {
            String string = DbmsMetadata.getDependentDDL(wbConnection, "OBJECT_GRANT", tableIdentifier.getTableName(), tableIdentifier.getSchema());
            StringBuilder stringBuilder = new StringBuilder(string == null ? 0 : string.length());
            stringBuilder.append(string);
            return stringBuilder;
        }
        return super.getViewGrantSource(wbConnection, tableIdentifier);
    }
}

