/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import workbench.db.DbObject;
import workbench.db.WbConnection;

public class ForeignServer
implements DbObject,
Serializable {
    public static final String TYPE_NAME = "FOREIGN SERVER";
    private String serverName;
    private String remarks;
    private Map<String, String> options = Collections.emptyMap();
    private String version;
    private String fdwName;
    private String type;

    public ForeignServer(String string) {
        this.serverName = string;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public void setOptions(Map<String, String> map) {
        this.options = map == null ? Collections.emptyMap() : new HashMap<String, String>(map);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getFdwName() {
        return this.fdwName;
    }

    public void setFdwName(String string) {
        this.fdwName = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public String getObjectType() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectName() {
        return this.serverName;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return this.serverName;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.serverName;
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.serverName;
    }

    public String toString() {
        return this.getObjectName();
    }

    public void setSource(String string) {
    }

    public String getSource() {
        String string = "CREATE SERVER " + this.serverName + "\n  FOREIGN DATA WRAPPER " + this.fdwName + "\n  OPTIONS (";
        boolean bl = true;
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                string = string + ", ";
            }
            string = string + entry.getKey() + " '" + entry.getValue() + "'";
        }
        string = string + ");";
        return string;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return this.getSource();
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("DROP SERVER ");
        stringBuilder.append(wbConnection.getMetadata().quoteObjectname(this.serverName));
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getComment() {
        return this.remarks;
    }

    @Override
    public void setComment(String string) {
        this.remarks = string;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

