/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.SQLException;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PgCollation
implements DbObject {
    public static final String TYPE_NAME = "COLLATION";
    private String name;
    private String remarks;
    private String schema;
    private String provider;
    private String collate;
    private String cType;

    public PgCollation(String string, String string2) {
        this.name = string2;
        this.schema = string;
    }

    public void setLocale(String string, String string2) {
        this.collate = string;
        this.cType = string2;
    }

    public String getCollate() {
        return this.collate;
    }

    public String getCType() {
        return this.cType;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getObjectType() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return SqlUtil.buildExpression(wbConnection, this);
    }

    public String toString() {
        return this.getObjectName();
    }

    public void setSource(String string) {
    }

    public String getSource() {
        return this.buildSource(SqlUtil.buildExpression(null, null, this.schema, this.name));
    }

    private String buildSource(String string) {
        String string2 = "CREATE COLLATION IF NOT EXISTS " + string + " (";
        if (StringUtil.isNonBlank(this.provider)) {
            string2 = string2 + "provider = " + this.provider + ", ";
        }
        string2 = string2 + "lc_collate='" + this.collate + "', lc_ctype='" + this.cType + "');";
        return string2;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return this.buildSource(SqlUtil.buildExpression(wbConnection, this));
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("DROP COLLATION IF EXISTS ");
        stringBuilder.append(this.getObjectNameForDrop(wbConnection));
        if (bl) {
            stringBuilder.append(" CASCADE");
        }
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getComment() {
        return this.remarks;
    }

    @Override
    public void setComment(String string) {
        this.remarks = string;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

