/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import workbench.WbManager;
import workbench.db.ArrayValueHandler;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionMgr;
import workbench.db.WbConnection;
import workbench.db.compare.BatchedStatement;
import workbench.db.postgres.PostgresDataTypeResolver;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class PostgresArrayHandler
implements ArrayValueHandler {
    private Class pgObjectClass;
    private Method setValue;
    private Method setType;
    private boolean useDefaultClassloader = WbManager.isTest();

    public PostgresArrayHandler(WbConnection wbConnection) {
        this.initialize(wbConnection);
    }

    private void initialize(WbConnection wbConnection) {
        try {
            String string = "org.postgresql.util.PGobject";
            this.pgObjectClass = this.useDefaultClassloader ? Class.forName(string) : ConnectionMgr.getInstance().loadClassFromDriverLib(wbConnection.getProfile(), string);
            this.setType = this.pgObjectClass.getMethod("setType", String.class);
            this.setValue = this.pgObjectClass.getMethod("setValue", String.class);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not access PGObject", throwable);
        }
    }

    @Override
    public void setValue(PreparedStatement preparedStatement, int n, Object object, ColumnIdentifier columnIdentifier) throws SQLException {
        Object object2 = this.createPgObject(object, columnIdentifier.getDbmsType());
        preparedStatement.setObject(n, object2);
    }

    @Override
    public void setValue(BatchedStatement batchedStatement, int n, Object object, ColumnIdentifier columnIdentifier) throws SQLException {
        Object object2 = this.createPgObject(object, columnIdentifier.getDbmsType());
        batchedStatement.setObject(n, object2);
    }

    private Object createPgObject(Object object, String string) {
        if (this.setValue == null) {
            return object;
        }
        if (this.setType == null) {
            return object;
        }
        String string2 = PostgresDataTypeResolver.mapArrayDisplayToInternal(string);
        if (string2 == null) {
            LogMgr.logDebug(new CallerInfo(){}, "No mapping for type: " + string);
            return object;
        }
        String string3 = this.adjustLiteral(object);
        try {
            Object t = this.pgObjectClass.newInstance();
            this.setType.invoke(t, string2);
            this.setValue.invoke(t, string3);
            return t;
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not create instance of PGobject", throwable);
            return object;
        }
    }

    private String adjustLiteral(Object object) {
        if (object == null) {
            return null;
        }
        String string = StringUtil.trimToNull(object.toString());
        if (this.isArrayLiteral(string)) {
            return string;
        }
        return "{" + string + "}";
    }

    private boolean isArrayLiteral(String string) {
        if (string == null) {
            return true;
        }
        if (string.length() < 2) {
            return false;
        }
        return string.charAt(0) == '{' && string.charAt(string.length() - 1) == '}';
    }
}

