/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresColumnEnhancer
implements ColumnDefinitionEnhancer {
    public static final int STORAGE_PLAIN = 1;
    public static final int STORAGE_MAIN = 2;
    public static final int STORAGE_EXTERNAL = 3;
    public static final int STORAGE_EXTENDED = 4;
    public static final String PROP_SHOW_REAL_SERIAL_DEF = "workbench.db.postgresql.serial.show";

    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        if (JdbcUtils.hasMinimumServerVersion(wbConnection, "8.0")) {
            this.readColumnInfo(tableDefinition, wbConnection);
        }
        this.updateSerials(tableDefinition);
    }

    public static String getStorageOption(int n) {
        switch (n) {
            case 4: {
                return "EXTENDED";
            }
            case 3: {
                return "EXTERNAL";
            }
            case 2: {
                return "MAIN";
            }
            case 1: {
                return "PLAIN";
            }
        }
        return null;
    }

    private void updateSerials(TableDefinition tableDefinition) {
        for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
            String string = columnIdentifier.getDbmsType();
            String string2 = columnIdentifier.getDefaultValue();
            if (!string.endsWith("serial") || string2 == null) continue;
            String string3 = "nextval('";
            if (string2.indexOf(46) > -1) {
                string3 = string3 + tableDefinition.getTable().getRawSchema() + ".";
            }
            string3 = string3 + tableDefinition.getTable().getRawTableName() + "_" + columnIdentifier.getColumnName() + "_seq'::regclass)";
            if (Settings.getInstance().getBoolProperty(PROP_SHOW_REAL_SERIAL_DEF, true) && string2.equals(string3)) {
                columnIdentifier.setDefaultValue(null);
                continue;
            }
            if (string.equals("serial")) {
                columnIdentifier.setDbmsType("integer");
            }
            if (!string.equals("bigserial")) continue;
            columnIdentifier.setDbmsType("bigint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readColumnInfo(TableDefinition tableDefinition, WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = JdbcUtils.hasMinimumServerVersion(wbConnection, "9.1");
        boolean bl2 = JdbcUtils.hasMinimumServerVersion(wbConnection, "10");
        boolean bl3 = JdbcUtils.hasMinimumServerVersion(wbConnection, "12");
        String string = bl ? "col.collcollate" : "null as collcollate";
        String string2 = (bl2 ? "nullif(att.attidentity, '') " : "null") + " as attidentity";
        String string3 = (bl3 ? "pg_get_expr(d.adbin, d.adrelid)" : "null") + " as generated_expr";
        String string4 = (bl3 ? "attgenerated" : "null") + " as attgenerated";
        String string5 = "select att.attname, \n       " + string + ", \n       case \n          when att.attlen = -1 then att.attstorage \n          else null \n       end as attstorage, \n       att.attinhcount, \n       att.attndims, \n       att.atthasdef, \n       pg_catalog.format_type(att.atttypid, att.atttypmod) as display_type, \n       " + string2 + ", \n       " + string3 + ", \n       " + string4 + " \nfrom pg_catalog.pg_attribute att  \n  join pg_catalog.pg_class tbl on tbl.oid = att.attrelid   \n  join pg_catalog.pg_namespace ns on tbl.relnamespace = ns.oid   \n" + (bl ? "  left join pg_catalog.pg_collation col on att.attcollation = col.oid \n" : "") + (bl3 ? "  left join pg_catalog.pg_attrdef d on d.adrelid = att.attrelid  and d.adnum = att.attnum \n" : "") + "where tbl.relname = ? \n  and ns.nspname = ? \n  and not att.attisdropped \n   and att.attname not in ('tableoid', 'cmax', 'xmax', 'cmin', 'xmin', 'ctid')";
        String string6 = tableDefinition.getTable().getRawTableName();
        String string7 = tableDefinition.getTable().getRawSchema();
        LogMgr.logMetadataSql(new CallerInfo(){}, "column information", string5, string6, string7);
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        Savepoint savepoint = null;
        try {
            savepoint = wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string5);
            preparedStatement.setString(1, string6);
            preparedStatement.setString(2, string7);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string8;
                String string9 = resultSet.getString("attname");
                String string10 = resultSet.getString("collcollate");
                String string11 = resultSet.getString("attstorage");
                int n = resultSet.getInt("attinhcount");
                boolean bl4 = resultSet.getBoolean("atthasdef");
                int n2 = resultSet.getInt("attndims");
                if (resultSet.wasNull()) {
                    n2 = -1;
                }
                String string12 = resultSet.getString("display_type");
                String string13 = resultSet.getString("attidentity");
                ColumnIdentifier columnIdentifier = tableDefinition.findColumn(string9);
                if (columnIdentifier == null) continue;
                if (StringUtil.isNonEmpty(string10)) {
                    columnIdentifier.setCollation(string10);
                    columnIdentifier.setCollationExpression(" COLLATE \"" + string10 + "\"");
                }
                if (n2 > 0) {
                    this.updateArrayType(columnIdentifier, string12, n2);
                }
                if (string13 != null) {
                    columnIdentifier.setIsAutoincrement(true);
                    columnIdentifier.setIsGenerated(true);
                    if ("d".equals(string13)) {
                        columnIdentifier.setGeneratorExpression("GENERATED BY DEFAULT AS IDENTITY");
                    } else if ("a".equals(string13)) {
                        columnIdentifier.setGeneratorExpression("GENERATED ALWAYS AS IDENTITY");
                        columnIdentifier.setIsIdentity(true);
                    }
                    arrayList.add(columnIdentifier);
                } else if (columnIdentifier.isAutoincrement() && !SqlUtil.isNumberType(columnIdentifier.getDataType()) && bl4) {
                    columnIdentifier.setIsAutoincrement(false);
                }
                columnIdentifier.setInherited(n > 0);
                if (string11 != null && !string11.isEmpty()) {
                    switch (string11.charAt(0)) {
                        case 'p': {
                            columnIdentifier.setPgStorage(1);
                            break;
                        }
                        case 'm': {
                            columnIdentifier.setPgStorage(2);
                            break;
                        }
                        case 'e': {
                            columnIdentifier.setPgStorage(3);
                            break;
                        }
                        case 'x': {
                            columnIdentifier.setPgStorage(4);
                        }
                    }
                }
                if (!"s".equals(string8 = resultSet.getString("attgenerated"))) continue;
                String string14 = resultSet.getString("generated_expr");
                columnIdentifier.setDefaultValue(null);
                columnIdentifier.setComputedColumnExpression("GENERATED ALWAYS AS " + string14 + " STORED");
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "column information", string5, string6, string7);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        if (arrayList.size() > 0) {
            this.adjustIdentitySequenceOptions(tableDefinition.getTable(), arrayList, wbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustIdentitySequenceOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, WbConnection wbConnection) {
        ResultSet resultSet;
        String string = "SELECT col.attname, s.seqstart, s.seqincrement, s.seqmax, s.seqmin, s.seqcache, s.seqcycle \nFROM pg_catalog.pg_sequence s \n  JOIN pg_catalog.pg_class seq on s.seqrelid = seq.oid \n  JOIN pg_catalog.pg_namespace sn ON sn.oid = seq.relnamespace  \n  JOIN pg_catalog.pg_depend d ON d.objid = seq.oid AND deptype in ('a', 'i') \n  JOIN pg_catalog.pg_class tab ON d.objid = seq.oid AND d.refobjid = tab.oid    \n  JOIN pg_catalog.pg_namespace ts on ts.oid = tab.relnamespace \n  JOIN pg_catalog.pg_attribute col ON (d.refobjid, d.refobjsubid) = (col.attrelid, col.attnum)  \nwhere ts.nspname = ? \n  and tab.relname = ? \n  and col.attname in (";
        boolean bl = true;
        for (ColumnIdentifier object2 : list) {
            if (bl) {
                bl = false;
            } else {
                string = string + ",";
            }
            string = string + "'" + SqlUtil.escapeQuotes(object2.getColumnName()) + "'";
        }
        string = string + ")";
        LogMgr.logMetadataSql(new CallerInfo(){}, "identity sequence information", string, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
        Object object3 = null;
        ResultSet resultSet2 = null;
        Savepoint savepoint = null;
        try {
            savepoint = wbConnection.setSavepoint();
            object3 = wbConnection.getSqlConnection().prepareStatement(string);
            object3.setString(1, tableIdentifier.getRawSchema());
            object3.setString(2, tableIdentifier.getRawTableName());
            resultSet = object3.executeQuery();
            while (resultSet.next()) {
                String string2 = "";
                String string3 = resultSet.getString(1);
                long l = resultSet.getLong(2);
                long l2 = resultSet.getLong(3);
                long l3 = resultSet.getLong(4);
                long l4 = resultSet.getLong(5);
                long l5 = resultSet.getLong(6);
                boolean bl2 = resultSet.getBoolean(7);
                if (l != 1L) {
                    string2 = string2 + "START WITH " + l;
                }
                if (l2 != 1L) {
                    string2 = string2 + " INCREMENT BY " + l2;
                }
                if (l3 != Integer.MAX_VALUE && l3 != Long.MAX_VALUE) {
                    string2 = string2 + " MAXVALUE " + l3;
                }
                if (l4 != 1L) {
                    string2 = string2 + " MINVALUE " + l4;
                }
                if (l5 != 1L) {
                    string2 = string2 + " CACHE " + l5;
                }
                if (bl2) {
                    string2 = string2 + " CYCLE";
                }
                if (string2.length() <= 0) continue;
                ColumnIdentifier columnIdentifier = ColumnIdentifier.findColumnInList(list, string3);
                String string4 = columnIdentifier.getGeneratorExpression();
                string4 = string4 + " (" + string2.trim() + ")";
                columnIdentifier.setGeneratorExpression(string4);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "identity sequence information", string, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet2, object3);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet2, (Statement)object3);
        }
        JdbcUtils.closeAll(resultSet, (Statement)object3);
    }

    private void updateArrayType(ColumnIdentifier columnIdentifier, String string, int n) {
        if (n <= 0) {
            return;
        }
        String string2 = StringUtil.replace(string, "character varying", "varchar");
        for (int i = 0; i < n - 1; ++i) {
            string2 = string2 + "[]";
        }
        columnIdentifier.setDbmsType(string2);
    }
}

