/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.util.Map;
import workbench.db.postgres.HstoreMap;
import workbench.storage.DataConverter;

public class PostgresDataConverter
implements DataConverter {
    public static PostgresDataConverter getInstance() {
        return LazyInstanceHolder.INSTANCE;
    }

    private PostgresDataConverter() {
    }

    @Override
    public boolean convertsType(int n, String string) {
        return n == 1111 && "hstore".equals(string);
    }

    @Override
    public Object convertValue(int n, String string, Object object) {
        if (this.convertsType(n, string) && object instanceof Map) {
            return new HstoreMap((Map)object);
        }
        return object;
    }

    @Override
    public Class getConvertedClass(int n, String string) {
        if (this.convertsType(n, string)) {
            return Map.class;
        }
        return null;
    }

    private static class LazyInstanceHolder {
        protected static final PostgresDataConverter INSTANCE = new PostgresDataConverter();

        private LazyInstanceHolder() {
        }
    }
}

