/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ProcedureDefinition;
import workbench.db.SequenceDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.db.postgres.InheritanceEntry;
import workbench.db.postgres.PostgresInheritanceReader;
import workbench.db.postgres.PostgresProcedureReader;
import workbench.db.postgres.PostgresPublicationReader;
import workbench.db.postgres.PostgresSubscriptionReader;
import workbench.gui.dbobjects.objecttree.DbObjectSorter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;

public class PostgresDependencyReader
implements DependencyReader {
    private final Set<String> supportedTypes = CollectionUtil.caseInsensitiveSet("table", "view", "sequence", "trigger", "function", "type");
    private final String typeCase = "       CASE cl.relkind \n          WHEN 'r' THEN 'TABLE'\n          WHEN 'i' THEN 'INDEX'\n          WHEN 'S' THEN 'SEQUENCE'\n          WHEN 'v' THEN 'VIEW'\n          WHEN 'm' THEN 'MATERIALIZED VIEW'\n          WHEN 'c' THEN 'TYPE'\n          WHEN 't' THEN 'TOAST'\n          WHEN 'f' THEN 'FOREIGN TABLE'\n       END AS object_type, \n";
    private final String proArgs = "       coalesce(array_to_string(p.proallargtypes, ';'), array_to_string(p.proargtypes, ';')) as arg_types, \n       array_to_string(p.proargnames, ';') as arg_names, \n       array_to_string(p.proargmodes, ';') as arg_modes, \n       p.oid::text as proc_id \n";
    private final String tablesUsedByView = "select vtu.table_schema, \n       vtu.table_name, \n       CASE cl.relkind \n          WHEN 'r' THEN 'TABLE'\n          WHEN 'i' THEN 'INDEX'\n          WHEN 'S' THEN 'SEQUENCE'\n          WHEN 'v' THEN 'VIEW'\n          WHEN 'm' THEN 'MATERIALIZED VIEW'\n          WHEN 'c' THEN 'TYPE'\n          WHEN 't' THEN 'TOAST'\n          WHEN 'f' THEN 'FOREIGN TABLE'\n       END AS object_type, \n       obj_description(cl.oid) as remarks\nfrom information_schema.view_table_usage vtu \n  join pg_catalog.pg_class cl on cl.oid = (quote_ident(vtu.table_schema)||'.'||quote_ident(vtu.table_name))::regclass \nwhere (vtu.view_schema, vtu.view_name) = (?, ?) \norder by vtu.view_schema, vtu.view_name";
    private final String viewsUsingTable = "select vtu.view_schema, \n       vtu.view_name, \n       CASE cl.relkind \n          WHEN 'r' THEN 'TABLE'\n          WHEN 'i' THEN 'INDEX'\n          WHEN 'S' THEN 'SEQUENCE'\n          WHEN 'v' THEN 'VIEW'\n          WHEN 'm' THEN 'MATERIALIZED VIEW'\n          WHEN 'c' THEN 'TYPE'\n          WHEN 't' THEN 'TOAST'\n          WHEN 'f' THEN 'FOREIGN TABLE'\n       END AS object_type, \n       obj_description(cl.oid) as remarks\nfrom information_schema.view_table_usage vtu \n  join pg_catalog.pg_class cl on cl.oid = (quote_ident(vtu.view_schema)||'.'||quote_ident(vtu.view_name))::regclass \nwhere (vtu.table_schema, vtu.table_name) = (?, ?) \norder by vtu.view_schema, vtu.view_name";
    private String typesUsedByFunction = "select distinct ts.nspname as type_schema, typ.typname as type_name, 'TYPE', obj_description(typ.oid) as remarks \nfrom pg_catalog.pg_proc c \n  join pg_catalog.pg_namespace n on n.oid = c.pronamespace \n  join pg_catalog.pg_depend d on d.objid = c.oid and d.refclassid = 'pg_type'::regclass \n  join pg_catalog.pg_type typ on typ.oid = d.refobjid \n  join pg_catalog.pg_namespace ts on ts.oid = typ.typnamespace \nwhere n.nspname = ? \n  and c.proname = ?";
    private final String functionsUsingType = "select distinct n.nspname as function_schema, p.proname as function_name, 'FUNCTION', obj_description(p.oid) as remarks, \n       coalesce(array_to_string(p.proallargtypes, ';'), array_to_string(p.proargtypes, ';')) as arg_types, \n       array_to_string(p.proargnames, ';') as arg_names, \n       array_to_string(p.proargmodes, ';') as arg_modes, \n       p.oid::text as proc_id \nfrom pg_catalog.pg_proc p \n  join pg_catalog.pg_namespace n on n.oid = p.pronamespace \n  join pg_catalog.pg_depend d on d.objid = p.oid and d.classid = 'pg_proc'::regclass \n  join pg_catalog.pg_type typ on typ.oid = d.refobjid \n  join pg_catalog.pg_namespace ts on ts.oid = typ.typnamespace \nwhere ts.nspname = ? \n  and typ.typname = ? \n";
    private final String tablesUsingType = "select distinct n.nspname as table_schema, \n        cl.relname as table_name, \n              CASE cl.relkind \n          WHEN 'r' THEN 'TABLE'\n          WHEN 'i' THEN 'INDEX'\n          WHEN 'S' THEN 'SEQUENCE'\n          WHEN 'v' THEN 'VIEW'\n          WHEN 'm' THEN 'MATERIALIZED VIEW'\n          WHEN 'c' THEN 'TYPE'\n          WHEN 't' THEN 'TOAST'\n          WHEN 'f' THEN 'FOREIGN TABLE'\n       END AS object_type, \n       obj_description(cl.oid) as remarks  \nfrom pg_catalog.pg_class cl  \n  join pg_catalog.pg_namespace n on n.oid = cl.relnamespace  \n  join pg_depend d on d.objid = cl.oid and d.classid = 'pg_class'::regclass  \n  join pg_catalog.pg_type t on t.oid = d.refobjid  \n  join pg_catalog.pg_namespace tn on tn.oid = t.typnamespace \nwhere d.deptype in ('a', 'n')  and cl.relkind in ('r', 'v', 'f') \n  and tn.nspname = ? \n  and t.typname = ? \n";
    private final String typesUsedByTable = "select distinct tn.nspname as type_schema, t.typname as type_name, 'TYPE' as object_type, obj_description(t.oid) as remarks \nfrom pg_catalog.pg_class c \n  join pg_catalog.pg_namespace n on n.oid = c.relnamespace \n  join pg_depend d on d.objid = c.oid and d.classid = 'pg_class'::regclass \n  join pg_catalog.pg_type t on t.oid = d.refobjid \n  join pg_catalog.pg_namespace tn on tn.oid = t.typnamespace\nwhere d.deptype in ('a', 'n') \n  and n.nspname = ? \n  and c.relname = ? ";
    private final String sequencesUsedByTable = "select distinct sn.nspname as sequence_schema, s.relname as sequence_name, 'SEQUENCE', obj_description(s.oid) as remarks\nfrom pg_catalog.pg_class s\n  join pg_catalog.pg_namespace sn on sn.oid = s.relnamespace \n  join pg_depend d on d.refobjid = s.oid and d.refclassid='pg_class'::regclass \n  join pg_attrdef ad on ad.oid = d.objid and d.classid = 'pg_attrdef'::regclass\n  join pg_attribute col on col.attrelid = ad.adrelid and col.attnum = ad.adnum\n  join pg_catalog.pg_class tbl on tbl.oid = ad.adrelid \n  join pg_catalog.pg_namespace ts on ts.oid = tbl.relnamespace \nwhere s.relkind = 'S' \n  and d.deptype in ('a', 'n') \n   and ts.nspname = ? \n  and tbl.relname = ?";
    private final String tablesUsingSequence = "select distinct n.nspname as table_schema, \n       cl.relname as table_name, \n              CASE cl.relkind \n          WHEN 'r' THEN 'TABLE'\n          WHEN 'i' THEN 'INDEX'\n          WHEN 'S' THEN 'SEQUENCE'\n          WHEN 'v' THEN 'VIEW'\n          WHEN 'm' THEN 'MATERIALIZED VIEW'\n          WHEN 'c' THEN 'TYPE'\n          WHEN 't' THEN 'TOAST'\n          WHEN 'f' THEN 'FOREIGN TABLE'\n       END AS object_type, \n       obj_description(cl.oid) as remarks\nfrom pg_catalog.pg_class s\n  join pg_catalog.pg_depend d on d.refobjid = s.oid and d.refclassid = 'pg_class'::regclass\n  join pg_catalog.pg_attrdef ad on ad.oid = d.objid and d.classid = 'pg_attrdef'::regclass\n  join pg_catalog.pg_attribute col on col.attrelid = ad.adrelid and col.attnum = ad.adnum\n  join pg_catalog.pg_class cl on cl.oid = ad.adrelid \n  join pg_catalog.pg_namespace n on n.oid = cl.relnamespace\n where s.relkind = 'S' \n  and d.deptype in ('a', 'n') \n   and n.nspname = ? \n  and s.relname = ?";
    private final String triggerImplementationFunction = "SELECT trgsch.nspname as function_schema, p.proname as function_name, 'FUNCTION', obj_description(p.oid) as remarks,        coalesce(array_to_string(p.proallargtypes, ';'), array_to_string(p.proargtypes, ';')) as arg_types, \n       array_to_string(p.proargnames, ';') as arg_names, \n       array_to_string(p.proargmodes, ';') as arg_modes, \n       p.oid::text as proc_id \nFROM pg_catalog.pg_trigger trg  \n  JOIN pg_catalog.pg_class tbl ON tbl.oid = trg.tgrelid  \n  JOIN pg_catalog.pg_proc p ON p.oid = trg.tgfoid \n  JOIN pg_catalog.pg_namespace trgsch ON trgsch.oid = p.pronamespace \n  JOIN pg_catalog.pg_namespace tblsch ON tblsch.oid = tbl.relnamespace \nWHERE tblsch.nspname =  ? \n  AND trg.tgname = ? ";
    private final String triggerTable = "SELECT tblsch.nspname as table_schema, tbl.relname as table_name, 'TABLE', obj_description(tbl.oid) as remarks \nFROM pg_catalog.pg_trigger trg  \n  JOIN pg_catalog.pg_class tbl ON tbl.oid = trg.tgrelid  \n  JOIN pg_catalog.pg_proc proc ON proc.oid = trg.tgfoid \n  JOIN pg_catalog.pg_namespace trgsch ON trgsch.oid = proc.pronamespace \n  JOIN pg_catalog.pg_namespace tblsch ON tblsch.oid = tbl.relnamespace \nWHERE tblsch.nspname =  ? \n  AND trg.tgname = ? ";
    private final String triggersUsingFunction = "SELECT trgsch.nspname as trigger_schema, trg.tgname as trigger_name, 'TRIGGER', obj_description(trg.oid) as remarks \nFROM pg_catalog.pg_trigger trg  \n  JOIN pg_catalog.pg_class tbl ON tbl.oid = trg.tgrelid  \n  JOIN pg_catalog.pg_proc proc ON proc.oid = trg.tgfoid \n  JOIN pg_catalog.pg_namespace trgsch ON trgsch.oid = proc.pronamespace \n  JOIN pg_catalog.pg_namespace tblsch ON tblsch.oid = tbl.relnamespace \nWHERE tblsch.nspname = ? \n  and proc.proname = ? ";
    private final PostgresProcedureReader procReader;

    public PostgresDependencyReader(WbConnection wbConnection) {
        this.procReader = new PostgresProcedureReader(wbConnection);
    }

    @Override
    public List<DbObject> getUsedObjects(WbConnection wbConnection, DbObject dbObject) {
        Object object;
        if (dbObject == null || wbConnection == null) {
            return Collections.emptyList();
        }
        String string = dbObject.getObjectType().toLowerCase();
        if (string.equals("subscription")) {
            return this.retrieveSubscriptionTables(wbConnection, dbObject);
        }
        if (string.equals("publication")) {
            return this.retrievePublicationTables(wbConnection, dbObject);
        }
        if (string.equals("function")) {
            return this.retrieveObjects(wbConnection, dbObject, this.typesUsedByFunction);
        }
        if (string.equals("trigger")) {
            return this.getTriggerFunction(wbConnection, dbObject);
        }
        List<DbObject> list = this.retrieveObjects(wbConnection, dbObject, "select vtu.table_schema, \n       vtu.table_name, \n       CASE cl.relkind \n          WHEN 'r' THEN 'TABLE'\n          WHEN 'i' THEN 'INDEX'\n          WHEN 'S' THEN 'SEQUENCE'\n          WHEN 'v' THEN 'VIEW'\n          WHEN 'm' THEN 'MATERIALIZED VIEW'\n          WHEN 'c' THEN 'TYPE'\n          WHEN 't' THEN 'TOAST'\n          WHEN 'f' THEN 'FOREIGN TABLE'\n       END AS object_type, \n       obj_description(cl.oid) as remarks\nfrom information_schema.view_table_usage vtu \n  join pg_catalog.pg_class cl on cl.oid = (quote_ident(vtu.table_schema)||'.'||quote_ident(vtu.table_name))::regclass \nwhere (vtu.view_schema, vtu.view_name) = (?, ?) \norder by vtu.view_schema, vtu.view_name");
        List<DbObject> list2 = this.retrieveObjects(wbConnection, dbObject, "select distinct sn.nspname as sequence_schema, s.relname as sequence_name, 'SEQUENCE', obj_description(s.oid) as remarks\nfrom pg_catalog.pg_class s\n  join pg_catalog.pg_namespace sn on sn.oid = s.relnamespace \n  join pg_depend d on d.refobjid = s.oid and d.refclassid='pg_class'::regclass \n  join pg_attrdef ad on ad.oid = d.objid and d.classid = 'pg_attrdef'::regclass\n  join pg_attribute col on col.attrelid = ad.adrelid and col.attnum = ad.adnum\n  join pg_catalog.pg_class tbl on tbl.oid = ad.adrelid \n  join pg_catalog.pg_namespace ts on ts.oid = tbl.relnamespace \nwhere s.relkind = 'S' \n  and d.deptype in ('a', 'n') \n   and ts.nspname = ? \n  and tbl.relname = ?");
        list.addAll(list2);
        if (string.equals("table") || string.equals("view") || string.equalsIgnoreCase("MATERIALIZED VIEW")) {
            object = this.retrieveObjects(wbConnection, dbObject, "select distinct tn.nspname as type_schema, t.typname as type_name, 'TYPE' as object_type, obj_description(t.oid) as remarks \nfrom pg_catalog.pg_class c \n  join pg_catalog.pg_namespace n on n.oid = c.relnamespace \n  join pg_depend d on d.objid = c.oid and d.classid = 'pg_class'::regclass \n  join pg_catalog.pg_type t on t.oid = d.refobjid \n  join pg_catalog.pg_namespace tn on tn.oid = t.typnamespace\nwhere d.deptype in ('a', 'n') \n  and n.nspname = ? \n  and c.relname = ? ");
            list.addAll((Collection<DbObject>)object);
        }
        object = new PostgresInheritanceReader();
        if (dbObject instanceof TableIdentifier && string.equals("table")) {
            List<TableIdentifier> list3 = ((PostgresInheritanceReader)object).getParents(wbConnection, (TableIdentifier)dbObject);
            for (TableIdentifier tableIdentifier : list3) {
                list.add(tableIdentifier);
            }
        }
        DbObjectSorter.sort(list, true);
        return list;
    }

    @Override
    public List<DbObject> getUsedBy(WbConnection wbConnection, DbObject dbObject) {
        Object object;
        if (dbObject == null || wbConnection == null) {
            return Collections.emptyList();
        }
        String string = dbObject.getObjectType().toLowerCase();
        if (string.equals("trigger")) {
            return this.retrieveObjects(wbConnection, dbObject, "SELECT tblsch.nspname as table_schema, tbl.relname as table_name, 'TABLE', obj_description(tbl.oid) as remarks \nFROM pg_catalog.pg_trigger trg  \n  JOIN pg_catalog.pg_class tbl ON tbl.oid = trg.tgrelid  \n  JOIN pg_catalog.pg_proc proc ON proc.oid = trg.tgfoid \n  JOIN pg_catalog.pg_namespace trgsch ON trgsch.oid = proc.pronamespace \n  JOIN pg_catalog.pg_namespace tblsch ON tblsch.oid = tbl.relnamespace \nWHERE tblsch.nspname =  ? \n  AND trg.tgname = ? ");
        }
        if (string.equals("function")) {
            return this.retrieveObjects(wbConnection, dbObject, "SELECT trgsch.nspname as trigger_schema, trg.tgname as trigger_name, 'TRIGGER', obj_description(trg.oid) as remarks \nFROM pg_catalog.pg_trigger trg  \n  JOIN pg_catalog.pg_class tbl ON tbl.oid = trg.tgrelid  \n  JOIN pg_catalog.pg_proc proc ON proc.oid = trg.tgfoid \n  JOIN pg_catalog.pg_namespace trgsch ON trgsch.oid = proc.pronamespace \n  JOIN pg_catalog.pg_namespace tblsch ON tblsch.oid = tbl.relnamespace \nWHERE tblsch.nspname = ? \n  and proc.proname = ? ");
        }
        List<DbObject> list = this.retrieveObjects(wbConnection, dbObject, "select vtu.view_schema, \n       vtu.view_name, \n       CASE cl.relkind \n          WHEN 'r' THEN 'TABLE'\n          WHEN 'i' THEN 'INDEX'\n          WHEN 'S' THEN 'SEQUENCE'\n          WHEN 'v' THEN 'VIEW'\n          WHEN 'm' THEN 'MATERIALIZED VIEW'\n          WHEN 'c' THEN 'TYPE'\n          WHEN 't' THEN 'TOAST'\n          WHEN 'f' THEN 'FOREIGN TABLE'\n       END AS object_type, \n       obj_description(cl.oid) as remarks\nfrom information_schema.view_table_usage vtu \n  join pg_catalog.pg_class cl on cl.oid = (quote_ident(vtu.view_schema)||'.'||quote_ident(vtu.view_name))::regclass \nwhere (vtu.table_schema, vtu.table_name) = (?, ?) \norder by vtu.view_schema, vtu.view_name");
        List<DbObject> list2 = this.retrieveObjects(wbConnection, dbObject, "select distinct n.nspname as table_schema, \n       cl.relname as table_name, \n              CASE cl.relkind \n          WHEN 'r' THEN 'TABLE'\n          WHEN 'i' THEN 'INDEX'\n          WHEN 'S' THEN 'SEQUENCE'\n          WHEN 'v' THEN 'VIEW'\n          WHEN 'm' THEN 'MATERIALIZED VIEW'\n          WHEN 'c' THEN 'TYPE'\n          WHEN 't' THEN 'TOAST'\n          WHEN 'f' THEN 'FOREIGN TABLE'\n       END AS object_type, \n       obj_description(cl.oid) as remarks\nfrom pg_catalog.pg_class s\n  join pg_catalog.pg_depend d on d.refobjid = s.oid and d.refclassid = 'pg_class'::regclass\n  join pg_catalog.pg_attrdef ad on ad.oid = d.objid and d.classid = 'pg_attrdef'::regclass\n  join pg_catalog.pg_attribute col on col.attrelid = ad.adrelid and col.attnum = ad.adnum\n  join pg_catalog.pg_class cl on cl.oid = ad.adrelid \n  join pg_catalog.pg_namespace n on n.oid = cl.relnamespace\n where s.relkind = 'S' \n  and d.deptype in ('a', 'n') \n   and n.nspname = ? \n  and s.relname = ?");
        list.addAll(list2);
        if (string.equals("type")) {
            list2 = this.retrieveObjects(wbConnection, dbObject, "select distinct n.nspname as table_schema, \n        cl.relname as table_name, \n              CASE cl.relkind \n          WHEN 'r' THEN 'TABLE'\n          WHEN 'i' THEN 'INDEX'\n          WHEN 'S' THEN 'SEQUENCE'\n          WHEN 'v' THEN 'VIEW'\n          WHEN 'm' THEN 'MATERIALIZED VIEW'\n          WHEN 'c' THEN 'TYPE'\n          WHEN 't' THEN 'TOAST'\n          WHEN 'f' THEN 'FOREIGN TABLE'\n       END AS object_type, \n       obj_description(cl.oid) as remarks  \nfrom pg_catalog.pg_class cl  \n  join pg_catalog.pg_namespace n on n.oid = cl.relnamespace  \n  join pg_depend d on d.objid = cl.oid and d.classid = 'pg_class'::regclass  \n  join pg_catalog.pg_type t on t.oid = d.refobjid  \n  join pg_catalog.pg_namespace tn on tn.oid = t.typnamespace \nwhere d.deptype in ('a', 'n')  and cl.relkind in ('r', 'v', 'f') \n  and tn.nspname = ? \n  and t.typname = ? \n");
            list.addAll(list2);
            object = this.retrieveObjects(wbConnection, dbObject, "select distinct n.nspname as function_schema, p.proname as function_name, 'FUNCTION', obj_description(p.oid) as remarks, \n       coalesce(array_to_string(p.proallargtypes, ';'), array_to_string(p.proargtypes, ';')) as arg_types, \n       array_to_string(p.proargnames, ';') as arg_names, \n       array_to_string(p.proargmodes, ';') as arg_modes, \n       p.oid::text as proc_id \nfrom pg_catalog.pg_proc p \n  join pg_catalog.pg_namespace n on n.oid = p.pronamespace \n  join pg_catalog.pg_depend d on d.objid = p.oid and d.classid = 'pg_proc'::regclass \n  join pg_catalog.pg_type typ on typ.oid = d.refobjid \n  join pg_catalog.pg_namespace ts on ts.oid = typ.typnamespace \nwhere ts.nspname = ? \n  and typ.typname = ? \n");
            list.addAll((Collection<DbObject>)object);
        }
        object = new PostgresInheritanceReader();
        if (dbObject instanceof TableIdentifier && string.equals("table")) {
            List<InheritanceEntry> list3 = ((PostgresInheritanceReader)object).getChildren(wbConnection, (TableIdentifier)dbObject);
            for (InheritanceEntry inheritanceEntry : list3) {
                list.add(inheritanceEntry.getTable());
            }
        }
        DbObjectSorter.sort(list, true);
        return list;
    }

    private List<DbObject> retrieveSubscriptionTables(WbConnection wbConnection, DbObject dbObject) {
        PostgresSubscriptionReader postgresSubscriptionReader = new PostgresSubscriptionReader();
        List<TableIdentifier> list = postgresSubscriptionReader.getTables(wbConnection, dbObject);
        return new ArrayList<DbObject>(list);
    }

    private List<DbObject> retrievePublicationTables(WbConnection wbConnection, DbObject dbObject) {
        PostgresPublicationReader postgresPublicationReader = new PostgresPublicationReader();
        List<TableIdentifier> list = postgresPublicationReader.getTables(wbConnection, dbObject);
        return new ArrayList<DbObject>(list);
    }

    private List<DbObject> getTriggerFunction(WbConnection wbConnection, DbObject dbObject) {
        return this.retrieveObjects(wbConnection, dbObject, "SELECT trgsch.nspname as function_schema, p.proname as function_name, 'FUNCTION', obj_description(p.oid) as remarks,        coalesce(array_to_string(p.proallargtypes, ';'), array_to_string(p.proargtypes, ';')) as arg_types, \n       array_to_string(p.proargnames, ';') as arg_names, \n       array_to_string(p.proargmodes, ';') as arg_modes, \n       p.oid::text as proc_id \nFROM pg_catalog.pg_trigger trg  \n  JOIN pg_catalog.pg_class tbl ON tbl.oid = trg.tgrelid  \n  JOIN pg_catalog.pg_proc p ON p.oid = trg.tgfoid \n  JOIN pg_catalog.pg_namespace trgsch ON trgsch.oid = p.pronamespace \n  JOIN pg_catalog.pg_namespace tblsch ON tblsch.oid = tbl.relnamespace \nWHERE tblsch.nspname =  ? \n  AND trg.tgname = ? ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DbObject> retrieveObjects(WbConnection wbConnection, DbObject dbObject, String string) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
        LogMgr.logMetadataSql(new CallerInfo(){}, "dependent objects", string, dbObject.getSchema(), dbObject.getObjectName(), dbObject.getObjectType());
        Savepoint savepoint = null;
        try {
            savepoint = wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, dbObject.getSchema());
            preparedStatement.setString(2, dbObject.getObjectName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object object;
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                String string5 = resultSet.getString(4);
                if (string4.equals("SEQUENCE")) {
                    object = new SequenceDefinition(null, string2, string3);
                    ((SequenceDefinition)object).setComment(string5);
                    arrayList.add((DbObject)object);
                    continue;
                }
                if (string4.equals("FUNCTION")) {
                    object = resultSet.getString("arg_types");
                    String string6 = resultSet.getString("arg_names");
                    String string7 = resultSet.getString("arg_modes");
                    String string8 = resultSet.getString("proc_id");
                    ProcedureDefinition procedureDefinition = this.procReader.createDefinition(string2, string3, string6, (String)object, string7, string8);
                    procedureDefinition.setComment(string5);
                    arrayList.add(procedureDefinition);
                    continue;
                }
                object = new TableIdentifier(null, string2, string3);
                ((TableIdentifier)object).setNeverAdjustCase(true);
                ((TableIdentifier)object).setComment(string5);
                ((TableIdentifier)object).setType(string4);
                arrayList.add((DbObject)object);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "dependent objects", string, dbObject.getSchema(), dbObject.getObjectName(), dbObject.getObjectType());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    @Override
    public boolean supportsUsedByDependency(String string) {
        return this.supportedTypes.contains(string);
    }

    @Override
    public boolean supportsIsUsingDependency(String string) {
        if ("sequence".equalsIgnoreCase(string)) {
            return false;
        }
        if ("SUBSCRIPTION".equalsIgnoreCase(string)) {
            return true;
        }
        if ("PUBLICATION".equalsIgnoreCase(string)) {
            return true;
        }
        return this.supportedTypes.contains(string);
    }
}

