/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.postgres.PgExtension;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresExtensionReader
implements ObjectListExtender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PgExtension> getExtensions(WbConnection wbConnection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<PgExtension> arrayList = new ArrayList<PgExtension>();
        StringBuilder stringBuilder = new StringBuilder("select nsp.nspname as schema_name, \n       ext.extname, \n       ext.extversion, \n       pg_catalog.obj_description(ext.oid) as remarks \nfrom pg_catalog.pg_extension ext \n  join pg_catalog.pg_namespace nsp on nsp.oid = extnamespace \n  join pg_catalog.pg_user u on u.usesysid = ext.extowner \nwhere ext.extname not in (select l.lanname from pg_language l) ");
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append("\n  and ");
            SqlUtil.appendExpression(stringBuilder, "ext.extname", string, wbConnection);
        }
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append("\n  and ");
            SqlUtil.appendExpression(stringBuilder, "nsp.nspname", string2, wbConnection);
        }
        stringBuilder.append("\norder by ext.extname");
        LogMgr.logMetadataSql(new CallerInfo(){}, "extensions", stringBuilder, new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                String string3 = resultSet.getString("extname");
                String string4 = resultSet.getString("schema_name");
                String string5 = resultSet.getString("extversion");
                String string6 = resultSet.getString("remarks");
                PgExtension pgExtension = new PgExtension(string4, string3);
                pgExtension.setVersion(string5);
                pgExtension.setComment(string6);
                arrayList.add(pgExtension);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "extensions", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public PgExtension getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<PgExtension> list = this.getExtensions(wbConnection, dbObject.getObjectName(), dbObject.getSchema());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("EXTENSION", stringArray)) {
            return false;
        }
        List<PgExtension> list = this.getExtensions(wbConnection, string3, string2);
        if (list.isEmpty()) {
            return false;
        }
        for (PgExtension pgExtension : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)pgExtension.getSchema());
            dataStore.setValue(n, 0, (Object)pgExtension.getObjectName());
            dataStore.setValue(n, 4, (Object)pgExtension.getComment());
            dataStore.setValue(n, 1, (Object)pgExtension.getObjectType());
            dataStore.getRow(n).setUserObject(pgExtension);
        }
        return true;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("EXTENSION", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("EXTENSION");
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        PgExtension pgExtension = this.getObjectDefinition(wbConnection, dbObject);
        if (pgExtension == null) {
            return null;
        }
        return pgExtension.getSource();
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

