/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import workbench.db.DefaultFKHandler;
import workbench.db.FKMatchType;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresFKHandler
extends DefaultFKHandler {
    public PostgresFKHandler(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public boolean supportsRemarks() {
        return true;
    }

    @Override
    public boolean shouldGenerate(FKMatchType fKMatchType) {
        return fKMatchType != null && fKMatchType != FKMatchType.SIMPLE;
    }

    @Override
    public boolean supportsMatchType() {
        return true;
    }

    @Override
    protected DataStore getRawKeyList(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        DataStore dataStore = super.getRawKeyList(tableIdentifier, bl);
        dataStore.addColumn(MATCH_TYPE_COLUMN);
        dataStore.addColumn(REMARKS_COLUMN);
        this.updateConstraintResult(tableIdentifier, dataStore);
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConstraintResult(TableIdentifier tableIdentifier, DataStore dataStore) {
        Object object;
        int n = dataStore.getColumnIndex("REMARKS");
        int n2 = dataStore.getColumnIndex("MATCH_TYPE");
        if (dataStore.getRowCount() <= 0) {
            return;
        }
        if (n < 0 || n2 < 0) {
            return;
        }
        int n3 = dataStore.getColumnIndex("FK_NAME");
        String string = "select c.conname, \n       c.confmatchtype, \n       pg_catalog.obj_description(c.oid, 'pg_constraint') as remarks\nfrom pg_catalog.pg_constraint c\n  join pg_catalog.pg_namespace s on s.oid = c.connamespace\nwhere contype = 'f' \n  and s.nspname = ? \n  and conname in (";
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            if (i > 0) {
                string = string + ',';
            }
            object = dataStore.getValueAsString(i, n3);
            string = string + "'" + SqlUtil.escapeQuotes((String)object) + "'";
        }
        string = string + ")";
        LogMgr.logMetadataSql(new CallerInfo(){}, "foreign key details", string, tableIdentifier.getRawSchema());
        PreparedStatement preparedStatement = null;
        object = null;
        try {
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            object = preparedStatement.executeQuery();
            while (object.next()) {
                String string2 = object.getString(1);
                FKMatchType fKMatchType = this.getMatchType(object.getString(2));
                String string3 = object.getString(3);
                int n4 = this.findConstraint(dataStore, n3, string2);
                if (n4 <= -1) continue;
                dataStore.setValue(n4, n, (Object)string3);
                dataStore.setValue(n4, n2, (Object)fKMatchType.toString());
            }
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, throwable, "foreign key details", string, tableIdentifier.getRawSchema());
            }
            catch (Throwable throwable2) {
                JdbcUtils.close(new AutoCloseable[]{preparedStatement, object});
                throw throwable2;
            }
            JdbcUtils.close(new AutoCloseable[]{preparedStatement, object});
        }
        JdbcUtils.close(new AutoCloseable[]{preparedStatement, object});
    }

    private FKMatchType getMatchType(String string) {
        if (StringUtil.isBlank(string)) {
            return FKMatchType.UNKNOWN;
        }
        switch (string) {
            case "f": {
                return FKMatchType.FULL;
            }
            case "p": {
                return FKMatchType.PARTIAL;
            }
            case "s": {
                return FKMatchType.SIMPLE;
            }
        }
        return FKMatchType.UNKNOWN;
    }

    private int findConstraint(DataStore dataStore, int n, String string) {
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string2 = dataStore.getValueAsString(i, n);
            if (!StringUtil.equalStringIgnoreCase(string2, string)) continue;
            return i;
        }
        return -1;
    }
}

