/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.PartitionLister;
import workbench.db.SubPartitionState;
import workbench.db.TableIdentifier;
import workbench.db.TablePartition;
import workbench.db.WbConnection;
import workbench.db.postgres.PostgresPartition;
import workbench.db.postgres.PostgresPartitionReader;

public class PostgresPartitionLister
implements PartitionLister {
    private final WbConnection conn;

    public PostgresPartitionLister(WbConnection wbConnection) {
        this.conn = wbConnection;
    }

    public List<PostgresPartition> getPartitions(TableIdentifier tableIdentifier) {
        PostgresPartitionReader postgresPartitionReader = new PostgresPartitionReader(tableIdentifier, this.conn);
        postgresPartitionReader.readPartitionInformation();
        List<PostgresPartition> list = postgresPartitionReader.getTablePartitions();
        ArrayList<PostgresPartition> arrayList = new ArrayList<PostgresPartition>();
        for (PostgresPartition postgresPartition : list) {
            postgresPartition.setSubPartitionState(SubPartitionState.none);
            if (postgresPartition.isSubPartition()) continue;
            arrayList.add(postgresPartition);
            List<PostgresPartition> list2 = this.extractSubPartitions(list, postgresPartition);
            if (list2.size() <= 0) continue;
            postgresPartition.setSubPartitions(list2);
            postgresPartition.setSubPartitionState(SubPartitionState.yes);
        }
        return arrayList;
    }

    private List<PostgresPartition> extractSubPartitions(List<PostgresPartition> list, PostgresPartition postgresPartition) {
        ArrayList<PostgresPartition> arrayList = new ArrayList<PostgresPartition>();
        String string = postgresPartition.getObjectName();
        for (PostgresPartition postgresPartition2 : list) {
            if (postgresPartition2.getParentTable() == null || !postgresPartition2.getParentTable().getRawTableName().equals(string)) continue;
            postgresPartition2.setSubPartitionState(SubPartitionState.none);
            postgresPartition2.setIsSubPartition(true);
            postgresPartition2.setPartitionStrategy(postgresPartition.getSubPartitionStrategy());
            postgresPartition2.setSubPartitionStrategy(null);
            arrayList.add(postgresPartition2);
        }
        return arrayList;
    }

    @Override
    public List<? extends TablePartition> getSubPartitions(TableIdentifier tableIdentifier, TablePartition tablePartition) {
        if (tablePartition instanceof PostgresPartition) {
            PostgresPartition postgresPartition = (PostgresPartition)tablePartition;
            return postgresPartition.getSubPartitions();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean supportsSubPartitions() {
        return true;
    }
}

