/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.CommentSqlManager;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.postgres.PgRangeType;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresRangeTypeReader
implements ObjectListExtender {
    public static boolean retrieveRangeTypes() {
        return Settings.getInstance().getBoolProperty("workbench.db.postgresql.rangetypes.retrieve", true);
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        boolean bl;
        boolean bl2 = bl = DbMetadata.typeIncluded("RANGE TYPE", stringArray) || DbMetadata.typeIncluded("TYPE", stringArray);
        if (!bl) {
            return false;
        }
        List<PgRangeType> list = this.getRangeTypes(wbConnection, string2, string3);
        for (PgRangeType pgRangeType : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)pgRangeType.getSchema());
            dataStore.setValue(n, 0, (Object)pgRangeType.getObjectName());
            dataStore.setValue(n, 1, (Object)pgRangeType.getObjectType());
            dataStore.setValue(n, 4, (Object)pgRangeType.getComment());
            dataStore.getRow(n).setUserObject(pgRangeType);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PgRangeType> getRangeTypes(WbConnection wbConnection, String string, String string2) {
        ArrayList<PgRangeType> arrayList = new ArrayList<PgRangeType>();
        StringBuilder stringBuilder = new StringBuilder(100);
        String string3 = "select t.typname as type_name,  \n       n.nspname as type_schema, \n       pg_catalog.obj_description(t.oid, 'pg_type') as remarks, \n       pg_catalog.format_type(rg.rngsubtype, NULL) as data_type \nFROM pg_catalog.pg_type t \n   join pg_catalog.pg_namespace n on t.typnamespace = n.oid \n   join pg_catalog.pg_range rg on t.oid = rg.rngtypid \nWHERE n.nspname NOT IN ('pg_catalog', 'information_schema')   AND t.typtype = 'r' \n";
        stringBuilder.append(string3);
        SqlUtil.appendAndCondition(stringBuilder, "n.nspname", string, wbConnection);
        SqlUtil.appendAndCondition(stringBuilder, "t.typname", string2, wbConnection);
        stringBuilder.append("\n ORDER BY 1,2 ");
        LogMgr.logMetadataSql(new CallerInfo(){}, "range types", stringBuilder, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                String string4 = resultSet.getString("type_schema");
                String string5 = resultSet.getString("type_name");
                String string6 = resultSet.getString("remarks");
                String string7 = resultSet.getString("data_type");
                PgRangeType pgRangeType = new PgRangeType(string4, string5);
                pgRangeType.setDataType(string7);
                pgRangeType.setComment(string6);
                arrayList.add(pgRangeType);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "range types", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public boolean isDerivedType() {
        return true;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("RANGE TYPE");
    }

    @Override
    public boolean handlesType(String string) {
        return "RANGE TYPE".equalsIgnoreCase(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        String[] stringArray = new String[]{"TYPE_NAME", "DATA_TYPE", "REMARKS"};
        int[] nArray = new int[]{12, 12, 12};
        DataStore dataStore = new DataStore(stringArray, nArray);
        PgRangeType pgRangeType = null;
        if (dbObject instanceof PgRangeType) {
            pgRangeType = (PgRangeType)dbObject;
        } else {
            List<PgRangeType> list = this.getRangeTypes(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
            if (list.size() == 1) {
                pgRangeType = list.get(0);
            }
        }
        if (pgRangeType != null) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 0, (Object)pgRangeType.getObjectName());
            dataStore.setValue(n, 1, (Object)pgRangeType.getDataType());
            dataStore.setValue(n, 2, (Object)pgRangeType.getComment());
        }
        return dataStore;
    }

    @Override
    public PgRangeType getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (dbObject instanceof PgRangeType) {
            return (PgRangeType)dbObject;
        }
        List<PgRangeType> list = this.getRangeTypes(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        PgRangeType pgRangeType = null;
        pgRangeType = dbObject instanceof PgRangeType ? (PgRangeType)dbObject : this.getObjectDefinition(wbConnection, dbObject);
        if (pgRangeType == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(50 + pgRangeType.getNumberOfAttributes() * 50);
        stringBuilder.append("CREATE TYPE ");
        stringBuilder.append(pgRangeType.getObjectName());
        stringBuilder.append(" AS RANGE\n");
        stringBuilder.append("(\n");
        stringBuilder.append("  SUBTYPE = ");
        stringBuilder.append(pgRangeType.getDataType());
        stringBuilder.append("\n);");
        String string = pgRangeType.getComment();
        CommentSqlManager commentSqlManager = new CommentSqlManager(wbConnection.getDbSettings().getDbId());
        String string2 = commentSqlManager.getCommentSqlTemplate("type", null);
        if (StringUtil.isNonBlank(string) && string2 != null) {
            string2 = string2.replace("%object_name%", pgRangeType.getObjectExpression(wbConnection));
            string2 = string2.replace("%comment%", string);
            stringBuilder.append("\n\n");
            stringBuilder.append(string2);
            stringBuilder.append(";\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

