/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.postgres.PostgresRule;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresRuleReader
implements ObjectListExtender {
    private final String baseSql = "select current_database() as rule_catalog,\n        n.nspname as rule_schema, \n       r.rulename as rule_name, \n       c.relname as rule_table, \n       case r.ev_type  \n         when '1' then 'SELECT' \n         when '2' then 'UPDATE' \n         when '3' then 'INSERT' \n         when '4' then 'DELETE' \n         else 'UNKNOWN' \n       end as rule_event, \n       pg_catalog.pg_get_ruledef(r.oid, true) as definition, \n       d.description as remarks \nfrom pg_catalog.pg_rewrite r  \n  join pg_catalog.pg_class c on r.ev_class = c.oid \n  left join pg_catalog.pg_namespace n on n.oid = c.relnamespace \n  left join pg_catalog.pg_description d on r.oid = d.objoid ";

    private String getSql(WbConnection wbConnection, String string, String string2, String string3, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append("select current_database() as rule_catalog,\n        n.nspname as rule_schema, \n       r.rulename as rule_name, \n       c.relname as rule_table, \n       case r.ev_type  \n         when '1' then 'SELECT' \n         when '2' then 'UPDATE' \n         when '3' then 'INSERT' \n         when '4' then 'DELETE' \n         else 'UNKNOWN' \n       end as rule_event, \n       pg_catalog.pg_get_ruledef(r.oid, true) as definition, \n       d.description as remarks \nfrom pg_catalog.pg_rewrite r  \n  join pg_catalog.pg_class c on r.ev_class = c.oid \n  left join pg_catalog.pg_namespace n on n.oid = c.relnamespace \n  left join pg_catalog.pg_description d on r.oid = d.objoid ");
        boolean bl2 = false;
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append("\n WHERE ");
            SqlUtil.appendExpression(stringBuilder, "r.rulename", string2, wbConnection);
            bl2 = true;
        }
        if (StringUtil.isNonBlank(string)) {
            if (!bl2) {
                stringBuilder.append("\n WHERE ");
                bl2 = true;
            } else {
                stringBuilder.append("\n AND ");
            }
            SqlUtil.appendExpression(stringBuilder, "n.nspname", string, wbConnection);
        }
        if (StringUtil.isNonBlank(string3)) {
            if (!bl2) {
                stringBuilder.append("\n WHERE ");
                bl2 = true;
            } else {
                stringBuilder.append("\n AND ");
            }
            SqlUtil.appendExpression(stringBuilder, "c.relname", string3, wbConnection);
        }
        if (bl) {
            if (!bl2) {
                stringBuilder.append("\n WHERE ");
                bl2 = true;
            } else {
                stringBuilder.append("\n AND");
            }
            stringBuilder.append(" not (c.relkind in ('v','m') and r.ev_type = '1')");
        }
        stringBuilder.append("\n ORDER BY 1, 2 ");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PostgresRule> getRuleList(WbConnection wbConnection, String string, String string2, String string3) {
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<PostgresRule> arrayList = new ArrayList<PostgresRule>();
        String string4 = this.getSql(wbConnection, string, string2, string3, DbSettings.getExcludePostgresDefaultRules());
        LogMgr.logMetadataSql(new CallerInfo(){}, "rules", string4, new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                String string5 = resultSet.getString("rule_catalog");
                String string6 = resultSet.getString("rule_schema");
                String string7 = resultSet.getString("rule_name");
                PostgresRule postgresRule = new PostgresRule(string5, string6, string7);
                postgresRule.setSource(resultSet.getString("definition"));
                postgresRule.setComment(resultSet.getString("remarks"));
                postgresRule.setEvent(resultSet.getString("rule_event"));
                String string8 = resultSet.getString("rule_table");
                postgresRule.setTable(new TableIdentifier(string5, string6, string8));
                arrayList.add(postgresRule);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "rules", string4, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    public List<PostgresRule> getTableRules(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        return this.getRuleList(wbConnection, tableIdentifier.getSchema(), null, tableIdentifier.getTableName());
    }

    public CharSequence getTableRuleSource(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        List<PostgresRule> list = this.getTableRules(wbConnection, tableIdentifier);
        if (CollectionUtil.isNonEmpty(list)) {
            StringBuilder stringBuilder = new StringBuilder(list.size() * 100);
            for (PostgresRule postgresRule : list) {
                try {
                    CharSequence charSequence = postgresRule.getSource(wbConnection);
                    stringBuilder.append(charSequence);
                    stringBuilder.append(Settings.getInstance().getInternalEditorLineEnding());
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Error retrieving rule source", sQLException);
                }
            }
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    public PostgresRule getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<PostgresRule> list = this.getRuleList(wbConnection, dbObject.getSchema(), dbObject.getObjectName(), null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("RULE", stringArray)) {
            return false;
        }
        List<PostgresRule> list = this.getRuleList(wbConnection, string2, string3, null);
        if (list.isEmpty()) {
            return false;
        }
        for (PostgresRule postgresRule : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)postgresRule.getSchema());
            dataStore.setValue(n, 0, (Object)postgresRule.getObjectName());
            dataStore.setValue(n, 4, (Object)postgresRule.getComment());
            dataStore.setValue(n, 1, (Object)postgresRule.getObjectType());
            dataStore.getRow(n).setUserObject(postgresRule);
        }
        return true;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("RULE", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        PostgresRule postgresRule = this.getObjectDefinition(wbConnection, dbObject);
        if (postgresRule == null) {
            return null;
        }
        String[] stringArray = new String[]{"RULE", "RULE_TABLE", "EVENT", "REMARKS"};
        int[] nArray = new int[]{12, 12, 12, 12};
        int[] nArray2 = new int[]{20, 20, 10, 30};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        dataStore.addRow();
        dataStore.setValue(0, 0, (Object)postgresRule.getObjectName());
        dataStore.setValue(0, 1, (Object)postgresRule.getTable().getObjectName());
        dataStore.setValue(0, 2, (Object)postgresRule.getEvent());
        dataStore.setValue(0, 3, (Object)postgresRule.getComment());
        return dataStore;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("RULE");
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        PostgresRule postgresRule = this.getObjectDefinition(wbConnection, dbObject);
        if (postgresRule == null) {
            return null;
        }
        return postgresRule.getSource();
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

