/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.redshift;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.DbSettings;
import workbench.db.DomainIdentifier;
import workbench.db.DropType;
import workbench.db.EnumIdentifier;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.ObjectSourceOptions;
import workbench.db.TableGrantReader;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.db.postgres.InheritanceEntry;
import workbench.db.postgres.PostgresColumnEnhancer;
import workbench.db.postgres.PostgresDomainReader;
import workbench.db.postgres.PostgresEnumReader;
import workbench.db.postgres.PostgresInheritanceReader;
import workbench.db.postgres.PostgresPartitionReader;
import workbench.db.postgres.PostgresRuleReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class RedshiftTableSourceBuilder
extends TableSourceBuilder {
    public RedshiftTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public String getTableSource(TableIdentifier tableIdentifier, DropType dropType, boolean bl, boolean bl2) throws SQLException {
        String string;
        if ("TABLE".equals(tableIdentifier.getType()) && (string = this.getBaseTableSource(tableIdentifier, dropType != DropType.none)) != null) {
            return string;
        }
        return super.getTableSource(tableIdentifier, dropType, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBaseTableSource(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        Object object;
        String string = "SELECT DDL FROM (\n  SELECT\n   table_id\n   ,REGEXP_REPLACE (schemaname, '^zzzzzzzz', '') AS schemaname\n   ,REGEXP_REPLACE (tablename, '^zzzzzzzz', '') AS tablename\n   ,seq\n   ,ddl\n  FROM\n   (\n   SELECT\n    table_id\n    ,schemaname\n    ,tablename\n    ,seq\n    ,ddl\n   FROM\n    (\n    SELECT";
        if (bl) {
            string = string + "    --DROP TABLE\n     c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n     ,c.relname AS tablename\n     ,0 AS seq\n     ,'DROP TABLE ' + QUOTE_IDENT(n.nspname) + '.' + QUOTE_IDENT(c.relname) + ';\\n\\n' AS ddl\n    FROM pg_namespace AS n\n    INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n    WHERE c.relkind = 'r'\n    UNION SELECT";
        }
        string = string + "    --CREATE TABLE\n     c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n     ,c.relname AS tablename\n     ,2 AS seq\n     ,'CREATE TABLE IF NOT EXISTS ' + QUOTE_IDENT(n.nspname) + '.' + QUOTE_IDENT(c.relname) + '\\n' AS ddl\n    FROM pg_namespace AS n\n    INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n    WHERE c.relkind = 'r'\n    --OPEN PAREN COLUMN LIST\n    UNION SELECT c.oid::bigint as table_id,n.nspname AS schemaname, c.relname AS tablename, 5 AS seq, '(\\n' AS ddl\n    FROM pg_namespace AS n\n    INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n    WHERE c.relkind = 'r'\n    --COLUMN LIST\n    UNION SELECT\n     table_id\n     ,schemaname\n     ,tablename\n     ,seq\n     ,'\\t' + col_delim + col_name + ' ' + col_datatype + ' ' + col_nullable + ' ' + col_default + ' ' + col_encoding + '\\n' AS ddl\n    FROM\n     (\n     SELECT\n      c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n      ,c.relname AS tablename\n      ,100000000 + a.attnum AS seq\n      ,CASE WHEN a.attnum > 1 THEN ',' ELSE '' END AS col_delim\n      ,QUOTE_IDENT(a.attname) AS col_name\n      ,CASE WHEN STRPOS(UPPER(format_type(a.atttypid, a.atttypmod)), 'CHARACTER VARYING') > 0\n        THEN REPLACE(UPPER(format_type(a.atttypid, a.atttypmod)), 'CHARACTER VARYING', 'VARCHAR')\n       WHEN STRPOS(UPPER(format_type(a.atttypid, a.atttypmod)), 'CHARACTER') > 0\n        THEN REPLACE(UPPER(format_type(a.atttypid, a.atttypmod)), 'CHARACTER', 'CHAR')\n       ELSE UPPER(format_type(a.atttypid, a.atttypmod))\n       END AS col_datatype\n      ,CASE WHEN format_encoding((a.attencodingtype)::integer) = 'none'\n       THEN ''\n       ELSE 'ENCODE ' + format_encoding((a.attencodingtype)::integer)\n       END AS col_encoding\n      ,CASE WHEN a.atthasdef IS TRUE THEN 'DEFAULT ' + adef.adsrc ELSE '' END AS col_default\n      ,CASE WHEN a.attnotnull IS TRUE THEN 'NOT NULL' ELSE '' END AS col_nullable\n     FROM pg_namespace AS n\n     INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n     INNER JOIN pg_attribute AS a ON c.oid = a.attrelid\n     LEFT OUTER JOIN pg_attrdef AS adef ON a.attrelid = adef.adrelid AND a.attnum = adef.adnum\n     WHERE c.relkind = 'r'\n       AND a.attnum > 0\n     ORDER BY a.attnum\n     )\n    --CONSTRAINT LIST\n    UNION (SELECT\n     c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n     ,c.relname AS tablename\n     ,200000000 + CAST(con.oid AS INT) AS seq\n     ,'\\t,' + pg_get_constraintdef(con.oid) + '\\n' AS ddl\n    FROM pg_constraint AS con\n    INNER JOIN pg_class AS c ON c.relnamespace = con.connamespace AND c.oid = con.conrelid\n    INNER JOIN pg_namespace AS n ON n.oid = c.relnamespace\n    WHERE c.relkind = 'r' AND pg_get_constraintdef(con.oid) NOT LIKE 'FOREIGN KEY%'\n    ORDER BY seq)\n    --CLOSE PAREN COLUMN LIST\n    UNION SELECT c.oid::bigint as table_id,n.nspname AS schemaname, c.relname AS tablename, 299999999 AS seq, ')\\n' AS ddl\n    FROM pg_namespace AS n\n    INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n    WHERE c.relkind = 'r'\n    --BACKUP\n    UNION SELECT\n    c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n     ,c.relname AS tablename\n     ,300000000 AS seq\n     ,'BACKUP NO\\n' as ddl\n  FROM pg_namespace AS n\n    INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n    INNER JOIN (SELECT\n      SPLIT_PART(key,'_',5) id\n      FROM pg_conf\n      WHERE key LIKE 'pg_class_backup_%'\n      AND SPLIT_PART(key,'_',4) = (SELECT\n        oid\n        FROM pg_database\n        WHERE datname = current_database())) t ON t.id=c.oid\n    WHERE c.relkind = 'r'\n    --BACKUP WARNING\n    UNION SELECT\n    c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n     ,c.relname AS tablename\n     ,1 AS seq\n     ,'--WARNING: This DDL inherited the BACKUP NO property from the source table\\n' as ddl\n  FROM pg_namespace AS n\n    INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n    INNER JOIN (SELECT\n      SPLIT_PART(key,'_',5) id\n      FROM pg_conf\n      WHERE key LIKE 'pg_class_backup_%'\n      AND SPLIT_PART(key,'_',4) = (SELECT\n        oid\n        FROM pg_database\n        WHERE datname = current_database())) t ON t.id=c.oid\n    WHERE c.relkind = 'r'\n    --DISTSTYLE\n    UNION SELECT\n     c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n     ,c.relname AS tablename\n     ,300000001 AS seq\n     ,CASE WHEN c.reldiststyle = 0 THEN 'DISTSTYLE EVEN'\n      WHEN c.reldiststyle = 1 THEN 'DISTSTYLE KEY'\n      WHEN c.reldiststyle = 8 THEN 'DISTSTYLE ALL'\n      ELSE '<<Error - UNKNOWN DISTSTYLE>>'\n      END + '\\n' AS ddl\n    FROM pg_namespace AS n\n    INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n    WHERE c.relkind = 'r'\n    --DISTKEY COLUMNS\n    UNION SELECT\n     c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n     ,c.relname AS tablename\n     ,400000000 + a.attnum AS seq\n     ,'DISTKEY (' + QUOTE_IDENT(a.attname) + ')\\n' AS ddl\n    FROM pg_namespace AS n\n    INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n    INNER JOIN pg_attribute AS a ON c.oid = a.attrelid\n    WHERE c.relkind = 'r'\n      AND a.attisdistkey IS TRUE\n      AND a.attnum > 0\n    --SORTKEY COLUMNS\n    UNION select table_id,schemaname, tablename, seq,\n         case when min_sort <0 then 'INTERLEAVED SORTKEY (' else 'SORTKEY (' end as ddl\n  from (SELECT\n     c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n     ,c.relname AS tablename\n     ,499999999 AS seq\n     ,min(attsortkeyord) min_sort FROM pg_namespace AS n\n    INNER JOIN  pg_class AS c ON n.oid = c.relnamespace\n    INNER JOIN pg_attribute AS a ON c.oid = a.attrelid\n    WHERE c.relkind = 'r'\n    AND abs(a.attsortkeyord) > 0\n    AND a.attnum > 0\n    group by 1,2,3,4 )\n    UNION (SELECT\n     c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n     ,c.relname AS tablename\n     ,500000000 + abs(a.attsortkeyord) AS seq\n     ,CASE WHEN abs(a.attsortkeyord) = 1\n      THEN QUOTE_IDENT(a.attname)\n      ELSE ', ' + QUOTE_IDENT(a.attname)\n      END AS ddl\n    FROM  pg_namespace AS n\n    INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n    INNER JOIN pg_attribute AS a ON c.oid = a.attrelid\n    WHERE c.relkind = 'r'\n      AND abs(a.attsortkeyord) > 0\n      AND a.attnum > 0\n    ORDER BY abs(a.attsortkeyord))\n    UNION SELECT\n     c.oid::bigint as table_id\n     ,n.nspname AS schemaname\n     ,c.relname AS tablename\n     ,599999999 AS seq\n     ,')\\n' AS ddl\n    FROM pg_namespace AS n\n    INNER JOIN  pg_class AS c ON n.oid = c.relnamespace\n    INNER JOIN  pg_attribute AS a ON c.oid = a.attrelid\n    WHERE c.relkind = 'r'\n      AND abs(a.attsortkeyord) > 0\n      AND a.attnum > 0\n    --END SEMICOLON\n    UNION SELECT c.oid::bigint as table_id ,n.nspname AS schemaname, c.relname AS tablename, 600000000 AS seq, ';\\n' AS ddl\n    FROM  pg_namespace AS n\n    INNER JOIN pg_class AS c ON n.oid = c.relnamespace\n    WHERE c.relkind = 'r' )\n    UNION (\n      SELECT c.oid::bigint as table_id,'zzzzzzzz' || n.nspname AS schemaname,\n         'zzzzzzzz' || c.relname AS tablename,\n         700000000 + CAST(con.oid AS INT) AS seq,\n         'ALTER TABLE ' + QUOTE_IDENT(n.nspname) + '.' + QUOTE_IDENT(c.relname) + ' ADD ' + pg_get_constraintdef(con.oid)::VARCHAR(1024) + ';' AS ddl\n      FROM pg_constraint AS con\n        INNER JOIN pg_class AS c\n               ON c.relnamespace = con.connamespace\n               AND c.oid = con.conrelid\n        INNER JOIN pg_namespace AS n ON n.oid = c.relnamespace\n      WHERE c.relkind = 'r'\n      AND con.contype = 'f'\n      ORDER BY seq\n    )\n   ORDER BY table_id,schemaname, tablename, seq\n   )\n ) X WHERE schemaname = ? and tablename = ? \n order by schemaname, tablename, seq";
        StringBuilder stringBuilder = new StringBuilder(100);
        LogMgr.logMetadataSql(new CallerInfo(){}, "table source", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getSchema());
            preparedStatement.setString(2, tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                stringBuilder.append((String)object);
            }
        }
        catch (SQLException sQLException) {
            String string2;
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table source", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
                string2 = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return string2;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        object = TableGrantReader.createReader(this.dbConnection);
        StringBuilder stringBuilder2 = ((TableGrantReader)object).getTableGrantSource(this.dbConnection, tableIdentifier);
        if (StringUtil.isNonBlank(stringBuilder2)) {
            stringBuilder.append("\n");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        if (objectSourceOptions.isInitialized()) {
            return;
        }
        PostgresRuleReader postgresRuleReader = new PostgresRuleReader();
        CharSequence charSequence = postgresRuleReader.getTableRuleSource(this.dbConnection, tableIdentifier);
        if (charSequence != null) {
            objectSourceOptions.setAdditionalSql(charSequence.toString());
        }
        if ("FOREIGN TABLE".equals(tableIdentifier.getType())) {
            this.readForeignTableOptions(tableIdentifier);
        } else {
            this.readTableOptions(tableIdentifier);
        }
        objectSourceOptions.setInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTableOptions(TableIdentifier tableIdentifier) {
        String string;
        String string2;
        String string3;
        if (!JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.1")) {
            return;
        }
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        StringBuilder stringBuilder = this.readInherits(tableIdentifier);
        StringBuilder stringBuilder2 = new StringBuilder();
        String string4 = null;
        string4 = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "9.1") ? "ct.relpersistence" : (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.4") ? "case when ct.relistemp then 't' else null::char end as relpersitence" : "null::char as relpersistence");
        boolean bl = this.dbConnection.getDbSettings().getBoolProperty("show.nonstandard.tablespace", true);
        if (JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.0")) {
            string3 = "spc.spcname";
            string2 = "ts.default_tablespace";
            string = "  cross join (\n    select ts.spcname as default_tablespace\n    from pg_database d\n      join pg_tablespace ts on ts.oid = d.dattablespace\n    where d.datname = current_database()\n  ) ts \n ";
        } else {
            string3 = "null as spcname";
            string2 = "null as default_tablespace";
            string = "";
            bl = false;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string5 = "select " + string4 + ", \n       ct.relkind, \n       array_to_string(ct.reloptions, ', ') as options, \n       " + string3 + ", \n       own.rolname as owner, \n       " + string2 + " \nfrom pg_catalog.pg_class ct \n  join pg_catalog.pg_namespace cns on ct.relnamespace = cns.oid \n   join pg_catalog.pg_roles own on ct.relowner = own.oid \n   left join pg_catalog.pg_tablespace spc on spc.oid = ct.reltablespace \n" + string + " where cns.nspname = ? \n   and ct.relname = ?";
        boolean bl2 = false;
        Savepoint savepoint = null;
        try {
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string5);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            LogMgr.logMetadataSql(new CallerInfo(){}, "table options", string5, tableIdentifier.getSchema(), tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string6 = resultSet.getString("relpersistence");
                String string7 = resultSet.getString("relkind");
                String string8 = resultSet.getString("options");
                String string9 = resultSet.getString("spcname");
                String string10 = resultSet.getString("owner");
                String string11 = resultSet.getString("default_tablespace");
                if (bl && !"pg_default".equals(string11) && StringUtil.isEmptyString(string9)) {
                    string9 = string11;
                }
                tableIdentifier.setOwner(string10);
                tableIdentifier.setTablespace(string9);
                if (StringUtil.isNonEmpty(string6)) {
                    switch (string6.charAt(0)) {
                        case 'u': {
                            objectSourceOptions.setTypeModifier("UNLOGGED");
                            break;
                        }
                        case 't': {
                            objectSourceOptions.setTypeModifier("TEMPORARY");
                        }
                    }
                }
                if ("f".equalsIgnoreCase(string7)) {
                    objectSourceOptions.setTypeModifier("FOREIGN");
                }
                if (!(bl2 = "p".equals(string7)) && stringBuilder != null) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append('\n');
                    }
                    stringBuilder2.append((CharSequence)stringBuilder);
                }
                if (StringUtil.isNonEmpty(string8)) {
                    this.setConfigSettings(string8, objectSourceOptions);
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append('\n');
                    }
                    stringBuilder2.append("WITH (");
                    stringBuilder2.append(string8);
                    stringBuilder2.append(")");
                }
                if (StringUtil.isNonBlank(string9)) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append('\n');
                    }
                    stringBuilder2.append("TABLESPACE ");
                    stringBuilder2.append(string9);
                }
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table options", string5, tableIdentifier.getSchema(), tableIdentifier.getTableName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        objectSourceOptions.setTableOption(stringBuilder2.toString());
        if (bl2) {
            this.handlePartitions(tableIdentifier);
        }
    }

    private void setConfigSettings(String string, ObjectSourceOptions objectSourceOptions) {
        List<String> list = StringUtil.stringToList(string, ",", true, true, false, true);
        for (String string2 : list) {
            String[] stringArray = string2.split("=");
            if (stringArray.length != 2) continue;
            objectSourceOptions.addConfigSetting(stringArray[0], stringArray[1]);
        }
    }

    private void handlePartitions(TableIdentifier tableIdentifier) {
        PostgresPartitionReader postgresPartitionReader = new PostgresPartitionReader(tableIdentifier, this.dbConnection);
        postgresPartitionReader.readPartitionInformation();
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        String string = postgresPartitionReader.getPartitionDefinition();
        String string2 = objectSourceOptions.getTableOption();
        string2 = string2 == null ? string : string + "\n" + string2;
        objectSourceOptions.setTableOption(string2);
        objectSourceOptions.addConfigSetting("partition_strategy", postgresPartitionReader.getStrategy().toLowerCase());
        objectSourceOptions.addConfigSetting("partition_expression", postgresPartitionReader.getPartitionExpression());
        String string3 = postgresPartitionReader.getCreatePartitions();
        if (string3 != null) {
            objectSourceOptions.setAdditionalSql(string3);
        }
    }

    private StringBuilder readInherits(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        PostgresInheritanceReader postgresInheritanceReader = new PostgresInheritanceReader();
        List<TableIdentifier> list = postgresInheritanceReader.getParents(this.dbConnection, tableIdentifier);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        stringBuilder = new StringBuilder(list.size() * 30);
        stringBuilder.append("INHERITS (");
        for (int i = 0; i < list.size(); ++i) {
            TableIdentifier tableIdentifier2 = list.get(i);
            tableIdentifier.getSourceOptions().addConfigSetting("inherits", tableIdentifier2.getTableName());
            stringBuilder.append(tableIdentifier2.getTableName());
            if (i <= 0) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readForeignTableOptions(TableIdentifier tableIdentifier) {
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        String string = "select ft.ftoptions, fs.srvname \nfrom pg_foreign_table ft \n  join pg_class tbl on tbl.oid = ft.ftrelid  \n  join pg_namespace ns on tbl.relnamespace = ns.oid  \n  join pg_foreign_server fs on ft.ftserver = fs.oid \n  WHERE tbl.relname = ? \n   and ns.nspname = ? ";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        StringBuilder stringBuilder = new StringBuilder(100);
        Savepoint savepoint = null;
        try {
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawTableName());
            preparedStatement.setString(2, tableIdentifier.getRawSchema());
            LogMgr.logMetadataSql(new CallerInfo(){}, "table options", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Array array = resultSet.getArray(1);
                String[] stringArray = array == null ? null : (String[])array.getArray();
                String string2 = resultSet.getString(2);
                stringBuilder.append("SERVER ");
                stringBuilder.append(string2);
                if (stringArray != null && stringArray.length > 0) {
                    stringBuilder.append("\nOPTIONS (");
                    for (int i = 0; i < stringArray.length; ++i) {
                        String[] stringArray2;
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        if ((stringArray2 = stringArray[i].split("=")).length != 2) continue;
                        stringBuilder.append(stringArray2[0] + " '" + stringArray2[1] + "'");
                    }
                    stringBuilder.append(')');
                }
                objectSourceOptions.setTableOption(stringBuilder.toString());
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.dbConnection.rollback(savepoint);
                savepoint = null;
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table options", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
                this.dbConnection.releaseSavepoint(savepoint);
            }
            catch (Throwable throwable) {
                this.dbConnection.releaseSavepoint(savepoint);
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    @Override
    public String getAdditionalTableInfo(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2) {
        String string = tableIdentifier.getSchemaToUse(this.dbConnection);
        CharSequence charSequence = this.getEnumInformation(list, string);
        CharSequence charSequence2 = this.getDomainInformation(list, string);
        CharSequence charSequence3 = this.getColumnSequenceInformation(tableIdentifier, list);
        CharSequence charSequence4 = null;
        CharSequence charSequence5 = null;
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        if (objectSourceOptions.getConfigSettings().get("partition_strategy") == null) {
            charSequence5 = this.getChildTables(tableIdentifier);
        }
        StringBuilder stringBuilder = this.getColumnStorage(tableIdentifier, list);
        String string2 = this.getOwnerSql(tableIdentifier);
        if (StringUtil.allEmpty(charSequence, charSequence2, charSequence3, charSequence5, string2, stringBuilder, charSequence4)) {
            return null;
        }
        StringBuilder stringBuilder2 = new StringBuilder(200);
        if (stringBuilder != null) {
            stringBuilder2.append((CharSequence)stringBuilder);
        }
        if (charSequence != null) {
            stringBuilder2.append(charSequence);
        }
        if (charSequence2 != null) {
            stringBuilder2.append(charSequence2);
        }
        if (charSequence3 != null) {
            stringBuilder2.append(charSequence3);
        }
        if (charSequence4 != null) {
            stringBuilder2.append(charSequence4);
        }
        if (charSequence5 != null) {
            stringBuilder2.append(charSequence5);
        }
        if (string2 != null) {
            stringBuilder2.append(string2);
        }
        return stringBuilder2.toString();
    }

    private StringBuilder getColumnStorage(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        StringBuilder stringBuilder = null;
        String string = tableIdentifier.getTableExpression(this.dbConnection);
        for (ColumnIdentifier columnIdentifier : list) {
            int n = columnIdentifier.getPgStorage();
            String string2 = PostgresColumnEnhancer.getStorageOption(n);
            if (string2 == null || this.isDefaultStorage(columnIdentifier.getDataType(), n)) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(50);
                stringBuilder.append('\n');
            }
            stringBuilder.append("ALTER TABLE ");
            stringBuilder.append(string);
            stringBuilder.append(" ALTER ");
            stringBuilder.append(this.dbConnection.getMetadata().quoteObjectname(columnIdentifier.getColumnName()));
            stringBuilder.append(" SET STORAGE ");
            stringBuilder.append(string2);
            stringBuilder.append(";\n");
        }
        return stringBuilder;
    }

    private boolean isDefaultStorage(int n, int n2) {
        if (n == 2 && n2 == 2) {
            return true;
        }
        return n2 == 4;
    }

    private String getOwnerSql(TableIdentifier tableIdentifier) {
        try {
            String string;
            DbSettings.GenerateOwnerType generateOwnerType = this.dbConnection.getDbSettings().getGenerateTableOwner();
            if (generateOwnerType == DbSettings.GenerateOwnerType.never) {
                return null;
            }
            String string2 = tableIdentifier.getOwner();
            if (StringUtil.isBlank(string2)) {
                return null;
            }
            if (generateOwnerType == DbSettings.GenerateOwnerType.whenNeeded && (string = this.dbConnection.getCurrentUser()).equalsIgnoreCase(string2)) {
                return null;
            }
            return "\nALTER TABLE " + tableIdentifier.getFullyQualifiedName(this.dbConnection) + " OWNER TO " + SqlUtil.quoteObjectname(string2) + ";";
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence getColumnSequenceInformation(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        if (!JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.4")) {
            return null;
        }
        if (tableIdentifier == null) {
            return null;
        }
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        String string = tableIdentifier.getTableExpression(this.dbConnection);
        ResultSet resultSet = null;
        Statement statement = null;
        StringBuilder stringBuilder = new StringBuilder(100);
        Savepoint savepoint = null;
        String string2 = null;
        try {
            savepoint = this.dbConnection.setSavepoint();
            statement = this.dbConnection.createStatementForQuery();
            for (ColumnIdentifier columnIdentifier : list) {
                String string3;
                String string4 = columnIdentifier.getDefaultValue();
                if (string4 != null && string4.toLowerCase().contains("nextval")) continue;
                String string5 = StringUtil.trimQuotes(columnIdentifier.getColumnName());
                string2 = "select pg_get_serial_sequence('" + string + "', '" + string5 + "')";
                resultSet = statement.executeQuery(string2);
                if (!resultSet.next() || !StringUtil.isNonBlank(string3 = resultSet.getString(1))) continue;
                String string6 = ResourceMgr.getFormattedString("TxtSequenceCol", columnIdentifier.getColumnName(), string3);
                stringBuilder.append("\n-- ");
                stringBuilder.append(string6);
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logWarning(new CallerInfo(){}, "Error reading sequence information using: " + string2, exception);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder;
    }

    private CharSequence getEnumInformation(List<ColumnIdentifier> list, String string) {
        PostgresEnumReader postgresEnumReader = new PostgresEnumReader();
        Map<String, EnumIdentifier> map = postgresEnumReader.getEnumInfo(this.dbConnection, string, null);
        if (CollectionUtil.isEmpty(map)) {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (ColumnIdentifier columnIdentifier : list) {
            String string2 = columnIdentifier.getDbmsType();
            EnumIdentifier enumIdentifier = map.get(string2);
            if (enumIdentifier == null) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(50);
            }
            stringBuilder.append("\n-- enum '");
            stringBuilder.append(string2);
            stringBuilder.append("': ");
            stringBuilder.append(StringUtil.listToString(enumIdentifier.getValues(), ",", true, '\''));
        }
        return stringBuilder;
    }

    public CharSequence getDomainInformation(List<ColumnIdentifier> list, String string) {
        PostgresDomainReader postgresDomainReader = new PostgresDomainReader();
        Map<String, DomainIdentifier> map = postgresDomainReader.getDomainInfo(this.dbConnection, string);
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (ColumnIdentifier columnIdentifier : list) {
            String string2 = columnIdentifier.getDbmsType();
            DomainIdentifier domainIdentifier = map.get(string2);
            if (domainIdentifier == null) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(50);
            }
            stringBuilder.append("\n-- domain '");
            stringBuilder.append(string2);
            stringBuilder.append("': ");
            stringBuilder.append(domainIdentifier.getSummary());
        }
        return stringBuilder;
    }

    protected CharSequence getChildTables(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        PostgresInheritanceReader postgresInheritanceReader = new PostgresInheritanceReader();
        List<InheritanceEntry> list = postgresInheritanceReader.getChildren(this.dbConnection, tableIdentifier);
        boolean bl = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.4");
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                stringBuilder = new StringBuilder(50);
                if (bl) {
                    stringBuilder.append("\n/* Inheritance tree:\n\n");
                    stringBuilder.append(tableIdentifier.getSchema());
                    stringBuilder.append('.');
                    stringBuilder.append(tableIdentifier.getTableName());
                } else {
                    stringBuilder.append("\n-- Child tables:");
                }
            }
            String string = list.get(i).getTable().getTableName();
            String string2 = list.get(i).getTable().getSchema();
            int n = list.get(i).getLevel();
            if (bl) {
                stringBuilder.append('\n');
                stringBuilder.append(StringUtil.padRight(" ", n * 2));
            } else {
                stringBuilder.append("\n--  ");
            }
            stringBuilder.append(string2);
            stringBuilder.append('.');
            stringBuilder.append(string);
        }
        if (bl && stringBuilder != null) {
            stringBuilder.append("\n*/");
        }
        return stringBuilder;
    }
}

