/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import workbench.db.ColumnIdentifier;
import workbench.db.report.ColumnReference;
import workbench.db.report.TagWriter;
import workbench.db.sqltemplates.ColumnDefinitionTemplate;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ReportColumn {
    public static final String TAG_COLUMN_DEFINITION = "column-def";
    public static final String TAG_COLUMN_NAME = "column-name";
    public static final String TAG_COLUMN_DBMS_TYPE = "dbms-data-type";
    public static final String TAG_COLUMN_JAVA_TYPE_NAME = "java-sql-type-name";
    public static final String TAG_COLUMN_JAVA_TYPE = "java-sql-type";
    public static final String TAG_COLUMN_JAVA_CLASS = "java-class";
    public static final String TAG_COLUMN_SIZE = "dbms-data-size";
    public static final String TAG_COLUMN_DIGITS = "dbms-data-digits";
    public static final String TAG_COLUMN_POSITION = "dbms-position";
    public static final String TAG_COLUMN_AUTO_INC = "auto-increment";
    public static final String TAG_COLUMN_GENERATED = "generated-column";
    public static final String TAG_COLUMN_DEFAULT = "default-value";
    public static final String TAG_COLUMN_COLLATION = "collation";
    public static final String TAG_COLUMN_NULLABLE = "nullable";
    public static final String TAG_COLUMN_PK = "primary-key";
    public static final String TAG_COLUMN_COMMENT = "comment";
    public static final String TAG_COLUMN_COMPUTED_COL = "computed-column-expression";
    private ColumnReference fk;
    private ColumnIdentifier column;
    private TagWriter tagWriter = new TagWriter();
    private boolean isRealColumn = true;
    private boolean isReferenced = false;
    private ColumnDefinitionTemplate template = new ColumnDefinitionTemplate();

    public ReportColumn(ColumnIdentifier columnIdentifier) {
        this.column = columnIdentifier;
    }

    public void setFixDefaultValue(boolean bl) {
        this.template.setFixDefaultValues(bl);
    }

    public ColumnIdentifier getColumn() {
        return this.column;
    }

    public ColumnReference getForeignKey() {
        return this.fk;
    }

    public void setIsReferenced(boolean bl) {
        this.isReferenced = bl;
    }

    public boolean isReferenced() {
        return this.isReferenced;
    }

    public void setForeignKeyReference(ColumnReference columnReference) {
        this.fk = columnReference;
    }

    public void appendXml(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        this.appendXml(stringBuilder, stringBuilder2, true);
    }

    public void appendXml(StringBuilder stringBuilder, StringBuilder stringBuilder2, boolean bl) {
        this.appendXml(stringBuilder, stringBuilder2, bl, TAG_COLUMN_DEFINITION, false);
    }

    public void appendXml(StringBuilder stringBuilder, StringBuilder stringBuilder2, boolean bl, String string, boolean bl2) {
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        if (bl2) {
            this.tagWriter.appendOpenTag(stringBuilder, stringBuilder2, string);
        } else {
            this.tagWriter.appendOpenTag(stringBuilder, stringBuilder2, string, "name", SqlUtil.removeObjectQuotes(this.column.getColumnName()));
        }
        stringBuilder.append('\n');
        if (bl) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_POSITION, this.column.getPosition());
        }
        if (!bl2) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_NAME, SqlUtil.removeObjectQuotes(this.column.getColumnName()));
        }
        this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_DBMS_TYPE, this.column.getDbmsType());
        if (this.isRealColumn && !bl2) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_PK, this.column.isPkColumn());
        }
        if (this.isRealColumn) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_NULLABLE, this.column.isNullable());
        }
        if (this.isRealColumn) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_DEFAULT, this.getDefaultValue(), true);
        }
        if (this.isRealColumn) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_AUTO_INC, this.column.isAutoincrement());
        }
        if (this.isRealColumn && this.column.isGenerated() != null) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_GENERATED, this.column.isGenerated());
        }
        this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_SIZE, this.column.getColumnSize());
        this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_DIGITS, this.column.getDigitsDisplay());
        if (!bl2) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_JAVA_TYPE, this.column.getDataType());
        }
        this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_JAVA_TYPE_NAME, SqlUtil.getTypeName(this.column.getDataType()));
        if (this.isRealColumn) {
            if (StringUtil.isNonBlank(this.column.getComputedColumnExpression())) {
                this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_COMPUTED_COL, this.column.getComputedColumnExpression(), true);
            }
            if (StringUtil.isNonBlank(this.column.getCollation())) {
                this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_COLLATION, this.column.getCollation());
            }
        }
        if (!bl2) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_COLUMN_COMMENT, this.column.getComment(), true);
        }
        if (this.fk != null) {
            stringBuilder.append((CharSequence)this.fk.getXml(stringBuilder3));
        }
        this.tagWriter.appendCloseTag(stringBuilder, stringBuilder2, string);
    }

    private String getDefaultValue() {
        if (this.column.getDefaultValue() == null) {
            return "";
        }
        return this.template.getDefaultExpression(this.column);
    }

    public void setIsRealColumn(boolean bl) {
        this.isRealColumn = bl;
    }

    public String toString() {
        return this.column.getColumnName();
    }
}

