/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.io.IOException;
import java.io.Writer;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.db.report.TagWriter;
import workbench.sql.DelimiterDefinition;
import workbench.util.StringUtil;

public class ReportProcedure {
    public static final String TAG_PROC_DEF = "proc-def";
    public static final String TAG_PROC_NAME = "proc-name";
    public static final String TAG_PROC_FULL_NAME = "proc-full-name";
    public static final String TAG_PROC_CATALOG = "proc-catalog";
    public static final String TAG_PROC_SCHEMA = "proc-schema";
    public static final String TAG_PROC_TYPE = "proc-type";
    public static final String TAG_PROC_SOURCE = "proc-source";
    public static final String TAG_PROC_COMMENT = "proc-comment";
    private ProcedureDefinition procDef;
    private WbConnection dbConn;
    private final TagWriter tagWriter = new TagWriter();
    private StringBuilder indent = new StringBuilder("  ");
    private StringBuilder indent2 = new StringBuilder("    ");
    private String schemaToUse;
    private String fullName;

    public ReportProcedure(ProcedureDefinition procedureDefinition, WbConnection wbConnection) {
        this.procDef = procedureDefinition;
        this.dbConn = wbConnection;
        this.fullName = procedureDefinition != null ? procedureDefinition.getDisplayName() : null;
    }

    public void setFullname(String string) {
        this.fullName = string;
    }

    public void setSchemaToUse(String string) {
        this.schemaToUse = string;
    }

    public String getSchema() {
        if (this.procDef == null) {
            return null;
        }
        return this.schemaToUse == null ? this.procDef.getSchema() : this.schemaToUse;
    }

    public CharSequence getSource() {
        if (this.procDef == null) {
            return null;
        }
        if (this.procDef.getSource() == null) {
            try {
                this.dbConn.getMetadata().getProcedureReader().readProcedureSource(this.procDef, null, this.schemaToUse);
            }
            catch (NoConfigException noConfigException) {
                this.procDef.setSource("n/a");
            }
        }
        return this.procDef.getSource();
    }

    public void writeXml(Writer writer) throws IOException {
        StringBuilder stringBuilder = this.getXml();
        writer.append(stringBuilder);
    }

    public ProcedureDefinition getProcedure() {
        return this.procDef;
    }

    public String getProcedureName() {
        return this.procDef.getProcedureName();
    }

    public void setIndent(StringBuilder stringBuilder) {
        this.indent = stringBuilder == null ? new StringBuilder(0) : stringBuilder;
        this.indent2 = new StringBuilder(this.indent);
        this.indent2.append("  ");
    }

    public StringBuilder getXml() {
        return this.getXml(true);
    }

    public StringBuilder getXml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(500);
        String string = this.procDef.getProcedureName();
        this.tagWriter.appendOpenTag(stringBuilder, this.indent, TAG_PROC_DEF);
        stringBuilder.append('\n');
        if (!this.procDef.isPackageProcedure() && this.procDef.getCatalog() != null) {
            this.tagWriter.appendTag(stringBuilder, this.indent2, TAG_PROC_CATALOG, this.procDef.getCatalog());
        } else if (this.procDef.isPackageProcedure()) {
            string = this.procDef.getPackageName();
        }
        this.tagWriter.appendTag(stringBuilder, this.indent2, TAG_PROC_SCHEMA, this.getSchema());
        this.tagWriter.appendTag(stringBuilder, this.indent2, TAG_PROC_NAME, string);
        if (StringUtil.isNonBlank(this.fullName) && StringUtil.stringsAreNotEqual(this.fullName, string)) {
            this.tagWriter.appendTag(stringBuilder, this.indent2, TAG_PROC_FULL_NAME, this.fullName);
        }
        if (StringUtil.isNonBlank(this.procDef.getComment())) {
            this.tagWriter.appendTag(stringBuilder, this.indent2, TAG_PROC_COMMENT, this.procDef.getComment());
        }
        this.tagWriter.appendTag(stringBuilder, this.indent2, TAG_PROC_TYPE, this.procDef.getObjectType(), "jdbcResultType", Integer.toString(this.procDef.getResultType()));
        if (bl) {
            String string2 = this.getSource().toString().trim();
            DelimiterDefinition delimiterDefinition = this.dbConn.getAlternateDelimiter();
            if (delimiterDefinition != null) {
                string2 = delimiterDefinition.removeFromEnd(string2);
            }
            this.tagWriter.appendTag(stringBuilder, this.indent2, TAG_PROC_SOURCE, string2, true);
        }
        this.tagWriter.appendCloseTag(stringBuilder, this.indent, TAG_PROC_DEF);
        return stringBuilder;
    }
}

