/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.sqltemplates;

import java.io.IOException;
import workbench.db.DbObject;
import workbench.db.QuoteHandler;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.FileUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public abstract class TemplateHandler {
    protected String getStringProperty(String string, String string2) {
        String string3 = Settings.getInstance().getProperty(string, string2);
        if (string3 != null && string3.startsWith("@file:")) {
            string3 = this.readFile(string3);
        }
        return string3;
    }

    private String readFile(String string) {
        String string2 = string.replace("@file:", "");
        WbFile wbFile = new WbFile(string2);
        if (!wbFile.isAbsolute()) {
            wbFile = new WbFile(Settings.getInstance().getConfigDir(), string2);
        }
        String string3 = null;
        try {
            LogMgr.logDebug(new CallerInfo(){}, "Reading SQL template from: " + wbFile.getAbsolutePath());
            string3 = FileUtil.readFile(wbFile, "UTF-8");
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not read file: " + string2, iOException);
            string3 = null;
        }
        return string3;
    }

    public static String removePlaceholder(String string, String string2, boolean bl) {
        String string3;
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(string2.length() + 10);
            stringBuilder.append("[ \\t]*");
            stringBuilder.append(StringUtil.quoteRegexMeta(string2));
            stringBuilder.append("[\n|\r\n]?");
            string3 = stringBuilder.toString();
        } else {
            string3 = StringUtil.quoteRegexMeta(string2);
        }
        return string.replaceAll(string3, "");
    }

    public static String replaceNamespaces(String string, String string2, String string3, WbConnection wbConnection) {
        string = TemplateHandler.replaceSchemaPlaceholder(string, string3, wbConnection);
        return TemplateHandler.replaceCatalogPlaceholder(string, string2, wbConnection);
    }

    public static String replaceSchemaPlaceholder(String string, String string2, WbConnection wbConnection) {
        char c = wbConnection.getMetadata().getSchemaSeparator();
        if (StringUtil.isBlank(string2)) {
            string = TemplateHandler.removeNamespacePlaceholder(string, "%schema_name%", c);
            string = TemplateHandler.removeNamespacePlaceholder(string, "%schema%", c);
        }
        if (string.contains("%schema_name%")) {
            return TemplateHandler.replacePlaceholder(string, "%schema_name%", string2, false);
        }
        return TemplateHandler.replacePlaceholder(string, "%schema%", string2, false);
    }

    public static String replaceCatalogPlaceholder(String string, String string2, WbConnection wbConnection) {
        char c = wbConnection.getMetadata().getCatalogSeparator();
        if (StringUtil.isBlank(string2)) {
            return TemplateHandler.removeNamespacePlaceholder(string, "%catalog_name%", c);
        }
        return TemplateHandler.replacePlaceholder(string, "%catalog_name%", wbConnection.getMetadata().quoteObjectname(string2), false);
    }

    public static String replaceTablePlaceholder(String string, DbObject dbObject, WbConnection wbConnection) {
        return TemplateHandler.replaceTablePlaceholder(string, dbObject, wbConnection, false);
    }

    public static String replaceTablePlaceholder(String string, DbObject dbObject, WbConnection wbConnection, boolean bl) {
        QuoteHandler quoteHandler;
        if (string == null) {
            return string;
        }
        if (dbObject == null) {
            return string;
        }
        QuoteHandler quoteHandler2 = quoteHandler = wbConnection == null ? QuoteHandler.STANDARD_HANDLER : wbConnection.getMetadata();
        if (quoteHandler == null) {
            quoteHandler = QuoteHandler.STANDARD_HANDLER;
        }
        string = dbObject.getSchema() == null ? TemplateHandler.removeSchemaPlaceholder(string, SqlUtil.getSchemaSeparator(wbConnection)) : TemplateHandler.replacePlaceholder(string, "%schema_name%", quoteHandler.quoteObjectname(dbObject.getSchema()), false);
        string = dbObject.getCatalog() == null ? TemplateHandler.removeCatalogPlaceholder(string, SqlUtil.getCatalogSeparator(wbConnection)) : TemplateHandler.replacePlaceholder(string, "%catalog_name%", quoteHandler.quoteObjectname(dbObject.getCatalog()), false);
        if (string.contains("%table_name%")) {
            string = TemplateHandler.replacePlaceholder(string, "%table_name%", quoteHandler.quoteObjectname(dbObject.getObjectName()), false);
        }
        if (string.contains("%object_name%")) {
            string = TemplateHandler.replacePlaceholder(string, "%object_name%", quoteHandler.quoteObjectname(dbObject.getObjectName()), false);
        }
        if (string.contains("%table_expression%")) {
            string = TemplateHandler.replacePlaceholder(string, "%table_expression%", dbObject.getObjectExpression(wbConnection), bl);
        }
        if (string.contains("%fq_table_name%")) {
            string = TemplateHandler.replacePlaceholder(string, "%fq_table_name%", dbObject.getFullyQualifiedName(wbConnection), bl);
        }
        if (string.contains("%fq_name%")) {
            string = TemplateHandler.replacePlaceholder(string, "%fq_name%", dbObject.getFullyQualifiedName(wbConnection), bl);
        }
        return string;
    }

    public static String removeSchemaPlaceholder(String string, char c) {
        return TemplateHandler.removeNamespacePlaceholder(string, "%schema_name%", c);
    }

    public static String removeCatalogPlaceholder(String string, char c) {
        return TemplateHandler.removeNamespacePlaceholder(string, "%catalog_name%", c);
    }

    public static String removeNamespacePlaceholder(String string, String string2, char c) {
        String string3 = TemplateHandler.removePlaceholder(string, string2, false);
        string3 = TemplateHandler.removePlaceholder(string, string2 + c, false);
        return string3;
    }

    public static String replacePlaceholder(String string, String string2, String string3, boolean bl) {
        char c;
        String string4;
        if (StringUtil.isEmptyString(string3)) {
            return TemplateHandler.removePlaceholder(string, string2, false);
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        String string5 = string3;
        if (n > 1) {
            string4 = "([\"'`";
            c = string.charAt(n - 1);
            if (bl && !Character.isWhitespace(c) && string4.indexOf(c) == -1) {
                string5 = " " + string5;
            }
        }
        if (n + string2.length() < string.length()) {
            string4 = ")]\"'`";
            c = string.charAt(n + string2.length());
            if (bl && !Character.isWhitespace(c) && string4.indexOf(c) == -1) {
                string5 = string5 + " ";
            }
        }
        return StringUtil.replace(string, string2, string5);
    }
}

