/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.vertica;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;

public class VerticaTableReader
implements ObjectListExtender {
    private String sql = "SELECT table_name as name, \n       decode(is_view,true,'SYSTEM VIEW',false,'SYSTEM TABLE') as type, \n       'v_internal' as schema, \n       current_database as catalog, \n       table_description as remarks \nFROM v_internal.vs_system_tables \nWHERE table_schema = 'v_internal' \nORDER BY table_name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        int n;
        if (!this.handlesType(stringArray)) {
            return false;
        }
        if (!DbMetadata.typeIncluded("SYSTEM TABLE", stringArray)) {
            return false;
        }
        if (string2 == null || !string2.equals("v_internal")) {
            return false;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "internal tables", this.sql, new Object[0]);
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(this.sql);
            while (resultSet.next()) {
                n = dataStore.addRow();
                dataStore.setValue(n, 2, (Object)resultSet.getString("catalog"));
                dataStore.setValue(n, 3, (Object)resultSet.getString("schema"));
                dataStore.setValue(n, 0, (Object)resultSet.getString("name"));
                dataStore.setValue(n, 4, (Object)resultSet.getString("remarks"));
                dataStore.setValue(n, 1, (Object)resultSet.getString("type"));
            }
            n = 1;
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "internal tables", this.sql, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
            return false;
        }
        JdbcUtils.closeAll(resultSet, statement);
        return n != 0;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("SYSTEM TABLE", "SYSTEM VIEW");
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return this.supportedTypes().contains(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public DbObject getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

