/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import workbench.db.DbObject;
import workbench.db.DbObjectChanger;
import workbench.db.DbSettings;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbTable;
import workbench.gui.dbobjects.ProcedureListPanel;
import workbench.gui.dbobjects.RunScriptPanel;
import workbench.interfaces.Reloadable;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class AlterProcedureAction
extends WbAction
implements TableModelListener {
    private WbTable procList;
    private WbConnection dbConnection;
    private Reloadable client;

    public AlterProcedureAction(WbTable wbTable) {
        this.procList = wbTable;
        this.initMenuDefinition("MnuTxtAlterObjects");
        this.procList.addTableModelListener(this);
        this.checkEnabled();
    }

    public void setReloader(Reloadable reloadable) {
        this.client = reloadable;
    }

    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        this.checkEnabled();
    }

    private void checkEnabled() {
        DataStore dataStore = this.procList != null ? this.procList.getDataStore() : null;
        boolean bl = dataStore != null ? dataStore.isModified() : false;
        this.setEnabled(bl && this.canAlterChangedTypes());
    }

    private boolean canAlterChangedTypes() {
        Object object;
        DataStore dataStore;
        if (this.dbConnection == null) {
            return false;
        }
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        if (dbSettings == null) {
            return false;
        }
        DataStore dataStore2 = dataStore = this.procList != null ? this.procList.getDataStore() : null;
        if (dataStore == null) {
            return false;
        }
        HashMap<DbObject, DbObject> hashMap = new HashMap<DbObject, DbObject>();
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            if (!dataStore.isRowModified(i)) continue;
            object = (DbObject)dataStore.getRow(i).getUserObject();
            ProcedureDefinition procedureDefinition = ProcedureListPanel.buildDefinitionFromDataStore(this.dbConnection, dataStore, i, true);
            hashMap.put((DbObject)object, procedureDefinition);
        }
        DbObjectChanger dbObjectChanger = new DbObjectChanger(this.dbConnection);
        object = dbObjectChanger.getAlterScript(hashMap);
        return StringUtil.isNonEmpty((CharSequence)object);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        String string = this.getScript();
        if (string == null) {
            WbSwingUtilities.showErrorMessageKey(this.procList, "MsgNoAlterAvailable");
        }
        RunScriptPanel runScriptPanel = new RunScriptPanel(this.dbConnection, string);
        runScriptPanel.openWindow(this.procList, ResourceMgr.getString("TxtAlterTable"));
        if (runScriptPanel.wasRun() && this.client != null) {
            EventQueue.invokeLater(this.client::reload);
        }
    }

    private String getScript() {
        DataStore dataStore = this.procList.getDataStore();
        DbObjectChanger dbObjectChanger = new DbObjectChanger(this.dbConnection);
        HashMap<DbObject, DbObject> hashMap = new HashMap<DbObject, DbObject>();
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            if (!dataStore.isRowModified(i)) continue;
            ProcedureDefinition procedureDefinition = ProcedureListPanel.buildDefinitionFromDataStore(this.dbConnection, dataStore, i, false);
            ProcedureDefinition procedureDefinition2 = ProcedureListPanel.buildDefinitionFromDataStore(this.dbConnection, dataStore, i, true);
            hashMap.put(procedureDefinition, procedureDefinition2);
        }
        return dbObjectChanger.getAlterScript(hashMap);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.checkEnabled();
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

