/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.resource.Settings;

public class CheckBoxAction
extends WbAction {
    private boolean switchedOn = false;
    private String settingsProperty;
    private JCheckBoxMenuItem toggleMenu;

    public CheckBoxAction(String string) {
        this(string, (String)null);
    }

    public CheckBoxAction(String string, String string2) {
        this.initMenuDefinition(string);
        this.setIcon(null);
        this.settingsProperty = string2;
        if (string2 != null) {
            this.switchedOn = Settings.getInstance().getBoolProperty(this.settingsProperty);
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.setSwitchedOn(!this.switchedOn);
    }

    public boolean isSwitchedOn() {
        return this.switchedOn;
    }

    public void setSwitchedOn(boolean bl) {
        if (bl == this.switchedOn) {
            return;
        }
        this.switchedOn = bl;
        if (this.toggleMenu != null) {
            WbSwingUtilities.invoke(() -> this.toggleMenu.setSelected(this.switchedOn));
        }
        if (this.settingsProperty != null) {
            Settings.getInstance().setProperty(this.settingsProperty, this.switchedOn);
        }
    }

    @Override
    public JMenuItem getMenuItem() {
        if (this.toggleMenu == null) {
            this.createMenuItem();
        }
        return this.toggleMenu;
    }

    private void createMenuItem() {
        this.toggleMenu = new JCheckBoxMenuItem();
        this.toggleMenu.setAction(this);
        String string = this.getValue("Name").toString();
        int n = string.indexOf(38);
        if (n > -1) {
            char c = string.charAt(n + 1);
            string = string.substring(0, n) + string.substring(n + 1);
            this.toggleMenu.setMnemonic((int)c);
        }
        this.toggleMenu.setText(string);
        this.toggleMenu.setSelected(this.switchedOn);
    }

    @Override
    public void addToMenu(JMenu jMenu) {
        if (this.toggleMenu == null) {
            this.createMenuItem();
        }
        jMenu.add(this.toggleMenu);
    }

    @Override
    public void setAccelerator(KeyStroke keyStroke) {
        super.setAccelerator(keyStroke);
        if (this.toggleMenu != null) {
            this.toggleMenu.setAccelerator(keyStroke);
        }
    }
}

