/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import workbench.db.WbConnection;
import workbench.gui.actions.CreateSnippetAction;
import workbench.gui.actions.WbAction;
import workbench.interfaces.TextContainer;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptParser;
import workbench.util.StringUtil;

public class CopyCurrentStatementAction
extends WbAction {
    private TextContainer script;
    private String dbid;
    private DelimiterDefinition alternateDelimiter;

    public CopyCurrentStatementAction(TextContainer textContainer) {
        this.initMenuDefinition("MnuTxtCopyCurrentStmt");
        this.setMenuItemName("MnuTxtSQL");
        this.script = textContainer;
    }

    public void setConnection(WbConnection wbConnection) {
        if (wbConnection == null) {
            this.dbid = null;
            this.alternateDelimiter = null;
        } else {
            this.dbid = wbConnection.getDbId();
            this.alternateDelimiter = wbConnection.getAlternateDelimiter();
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        String string = this.script.getText();
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        ScriptParser scriptParser = new ScriptParser(string, ParserType.getTypeFromDBID(this.dbid));
        scriptParser.setAlternateDelimiter(this.alternateDelimiter);
        scriptParser.setCheckEscapedQuotes(Settings.getInstance().useNonStandardQuoteEscaping(this.dbid));
        scriptParser.setEmptyLineIsDelimiter(Settings.getInstance().getEmptyLineIsDelimiter());
        int n = this.script.getCaretPosition();
        int n2 = scriptParser.getCommandIndexAtCursorPos(n);
        String string2 = scriptParser.getCommand(n2);
        string2 = string2 + "\n;\n";
        boolean bl = false;
        if (CopyCurrentStatementAction.invokedByMouse(actionEvent) && CopyCurrentStatementAction.isCtrlPressed(actionEvent)) {
            bl = true;
        }
        if (bl) {
            string2 = CreateSnippetAction.makeJavaString(string2, true);
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string2);
        clipboard.setContents(stringSelection, stringSelection);
    }
}

