/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import workbench.db.ConnectionProfile;
import workbench.gui.MainWindow;
import workbench.gui.actions.WbAction;

public class DisconnectTabAction
extends WbAction {
    private MainWindow window;

    public DisconnectTabAction(MainWindow mainWindow) {
        this.initMenuDefinition("MnuTxtDisconnectTab");
        this.setMenuItemName("MnuTxtFile");
        this.setEnabled(false);
        this.window = mainWindow;
        this.checkState();
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.window == null) {
            return;
        }
        ConnectionProfile connectionProfile = this.window.getCurrentProfile();
        if (connectionProfile.getUseSeparateConnectionPerTab()) {
            return;
        }
        this.window.disconnectCurrentPanel();
    }

    public void checkState() {
        if (this.window == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.window.canUseSeparateConnection() && this.window.usesSeparateConnection());
        }
    }
}

