/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbTable;
import workbench.gui.sql.RecordFormPanel;
import workbench.resource.ResourceMgr;

public class DisplayDataFormAction
extends WbAction
implements TableModelListener {
    private WbTable client;

    public DisplayDataFormAction(WbTable wbTable) {
        this.setEnabled(false);
        this.initMenuDefinition("MnuTxtShowRecord");
        this.removeIcon();
        this.setMenuItemName("MnuTxtData");
        this.setTable(wbTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.client.getRowCount() == 0) {
            return;
        }
        int n = this.client.getEditingRow();
        if (n < 0) {
            n = this.client.getSelectedRow();
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = this.client.getEditingColumn();
        if (this.client.isStatusColumnVisible()) {
            --n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        RecordFormPanel recordFormPanel = new RecordFormPanel(this.client, n, n2);
        Frame frame = (Frame)SwingUtilities.getWindowAncestor(this.client);
        ValidatingDialog validatingDialog = new ValidatingDialog(frame, ResourceMgr.getString("TxtWindowTitleForm"), (JComponent)recordFormPanel);
        Dimension dimension = validatingDialog.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (int)((double)dimension2.width * 0.6);
        int n4 = (int)((double)dimension2.height * 0.6);
        Dimension dimension3 = new Dimension(n3, n4);
        recordFormPanel.setMaximumSize(dimension3);
        validatingDialog.setMaximumSize(dimension3);
        boolean bl = false;
        if (dimension.height > dimension3.height) {
            bl = true;
            UIDefaults uIDefaults = UIManager.getDefaults();
            int n5 = uIDefaults.getInt("ScrollBar.width");
            if (n5 <= 0) {
                n5 = 32;
            }
            dimension.width += n5 + 2;
        }
        if (dimension.width > dimension3.width) {
            bl = true;
        }
        if (bl) {
            validatingDialog.setPreferredSize(dimension3);
        }
        validatingDialog.pack();
        try {
            WbSwingUtilities.center(validatingDialog, frame);
            validatingDialog.setVisible(true);
        }
        finally {
            validatingDialog.dispose();
        }
    }

    public void setTable(WbTable wbTable) {
        if (this.client != null && this.client != wbTable) {
            this.client.removeTableModelListener(this);
        }
        this.client = wbTable;
        this.setEnabled(this.client != null && this.client.getRowCount() > 0);
        if (this.client != null) {
            this.client.addTableModelListener(this);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setEnabled(this.client != null && this.client.getRowCount() > 0);
    }
}

