/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Map;
import workbench.db.DbObjectChanger;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.FkDisplayPanel;
import workbench.gui.dbobjects.RunScriptPanel;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class DropForeignKeyAction
extends WbAction {
    private final FkDisplayPanel fkDisplay;

    public DropForeignKeyAction(FkDisplayPanel fkDisplayPanel) {
        this.initMenuDefinition("MnuTxtDropFK");
        this.fkDisplay = fkDisplayPanel;
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        TableIdentifier tableIdentifier = this.fkDisplay.getCurrentTable();
        if (tableIdentifier == null) {
            return;
        }
        WbConnection wbConnection = this.fkDisplay.getConnection();
        if (wbConnection == null || wbConnection.isBusy()) {
            return;
        }
        Map<TableIdentifier, String> map = this.fkDisplay.getSelectedForeignKeys();
        if (CollectionUtil.isEmpty(map)) {
            return;
        }
        DbObjectChanger dbObjectChanger = new DbObjectChanger(wbConnection);
        String string = dbObjectChanger.getDropFKScript(map);
        if (StringUtil.isBlank(string)) {
            return;
        }
        RunScriptPanel runScriptPanel = new RunScriptPanel(wbConnection, string);
        runScriptPanel.openWindow(this.fkDisplay, ResourceMgr.getString("TxtDropConstraint"));
        if (runScriptPanel.wasRun()) {
            EventQueue.invokeLater(this.fkDisplay::reloadTable);
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

