/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;

public class FileDisconnectAction
extends WbAction {
    private MainWindow window;

    public FileDisconnectAction(MainWindow mainWindow) {
        this.window = mainWindow;
        this.initMenuDefinition("MnuTxtDisconnect");
        this.setEnabled(false);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        LogMgr.logDebug(new CallerInfo(){}, "Initiating disconnect.");
        if (FileDisconnectAction.isCtrlPressed(actionEvent) && FileDisconnectAction.invokedByMouse(actionEvent)) {
            boolean bl = WbSwingUtilities.getYesNo(this.window, ResourceMgr.getString("MsgAbortWarning"));
            if (bl) {
                this.window.forceDisconnect();
            }
        } else {
            this.window.disconnect(true, true, true, true);
        }
    }
}

