/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.List;
import javax.swing.KeyStroke;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.JoinCompletionPopup;
import workbench.gui.actions.WbAction;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.sql.EditorPanel;
import workbench.gui.sql.SqlPanel;
import workbench.interfaces.StatusBar;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.fksupport.JoinCondition;
import workbench.sql.fksupport.JoinCreator;
import workbench.sql.parser.ScriptParser;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.TableAlias;

public class JoinCompletionAction
extends WbAction {
    protected SqlPanel client;

    public JoinCompletionAction(SqlPanel sqlPanel) {
        this.client = sqlPanel;
        this.initMenuDefinition("MnuTxtAutoCompleteJoin", KeyStroke.getKeyStroke(74, 8));
        this.setMenuItemName("MnuTxtSQL");
        this.setEnabled(false);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        WbConnection wbConnection = this.client.getConnection();
        if (wbConnection == null) {
            return;
        }
        ScriptParser scriptParser = ScriptParser.createScriptParser(this.client.getConnection());
        EditorPanel editorPanel = this.client.getEditor();
        scriptParser.setScript(editorPanel.getText());
        int n = editorPanel.getCaretPosition();
        int n2 = scriptParser.getCommandIndexAtCursorPos(n);
        int n3 = scriptParser.getIndexInCommand(n2, n);
        String string = scriptParser.getCommand(n2, false);
        if (string == null) {
            LogMgr.logWarning(new CallerInfo(){}, "No SQL found!");
            return;
        }
        String string2 = wbConnection.getParsingUtil().getSqlVerb(string);
        if (!"SELECT".equalsIgnoreCase(string2)) {
            String string3 = "'" + string2 + "' " + ResourceMgr.getString("MsgCompletionNotSupported");
            this.setStatusMessage(string3, 2500);
            return;
        }
        try {
            this.setStatusMessage(ResourceMgr.getString("MsgCompletionRetrievingObjects"), 0);
            JoinCreator joinCreator = new JoinCreator(string, n3, wbConnection);
            List<JoinCondition> list = joinCreator.getJoinConditions();
            List<TableAlias> list2 = joinCreator.getPossibleJoinTables();
            if (CollectionUtil.isEmpty(list) && list2.size() == 1) {
                list = joinCreator.getJoinConditions(list2.get(0));
            }
            if (list.size() > 1) {
                this.setStatusMessage("", 0);
                List<JoinCondition> list3 = list;
                EventQueue.invokeLater(() -> {
                    JoinCompletionPopup joinCompletionPopup = new JoinCompletionPopup((JEditTextArea)editorPanel, list3, joinCreator);
                    joinCompletionPopup.setStatusBar(this.client.getStatusBar());
                    joinCompletionPopup.showPopup();
                });
            } else if (list.size() == 1) {
                String string4 = joinCreator.getJoinCondition(list.get(0));
                editorPanel.insertText(string4 + " ");
                this.setStatusMessage("", 0);
            } else if (list2.size() > 1) {
                this.setStatusMessage("", 0);
                EventQueue.invokeLater(() -> {
                    JoinCompletionPopup joinCompletionPopup = new JoinCompletionPopup((JEditTextArea)editorPanel, list2, joinCreator);
                    joinCompletionPopup.setStatusBar(this.client.getStatusBar());
                    joinCompletionPopup.showPopup();
                });
            } else {
                this.setStatusMessage(ResourceMgr.getString("MsgCompletionNothingFound"), 2500);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logWarning(new CallerInfo(){}, "Error retrieving condition", sQLException);
            this.setStatusMessage("", 0);
        }
    }

    private void setStatusMessage(String string, int n) {
        StatusBar statusBar = this.client.getStatusBar();
        if (statusBar == null) {
            return;
        }
        WbSwingUtilities.invoke(() -> {
            if (StringUtil.isEmptyString(string)) {
                statusBar.clearStatusMessage();
            } else if (n > 0) {
                statusBar.setStatusMessage(string, n);
            } else {
                statusBar.setStatusMessage(string);
            }
            statusBar.doRepaint();
        });
    }
}

