/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import workbench.gui.actions.WbAction;
import workbench.gui.menu.RecentFileManager;
import workbench.interfaces.MacroChangeListener;
import workbench.sql.macros.MacroFileSelector;
import workbench.sql.macros.MacroManager;
import workbench.sql.macros.MacroStorage;
import workbench.util.WbFile;

public class SaveMacrosAction
extends WbAction
implements MacroChangeListener {
    private final int macroClientId;
    private Component parent;

    public SaveMacrosAction(Component component, int n) {
        this.macroClientId = n;
        this.parent = component;
        this.initMenuDefinition("MnuTxtSaveMacros");
        this.setMenuItemName("MnuTxtMacro");
        this.setIcon(null);
        MacroStorage macroStorage = MacroManager.getInstance().getMacros(this.macroClientId);
        if (macroStorage != null) {
            macroStorage.addChangeListener(this);
            String string = macroStorage.getCurrentMacroFilename();
            this.setTooltip(string);
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        MacroFileSelector macroFileSelector = new MacroFileSelector();
        WbFile wbFile = macroFileSelector.selectStorageForSave(this.parent, this.macroClientId);
        if (wbFile == null) {
            return;
        }
        MacroManager.getInstance().saveAs(this.macroClientId, wbFile);
        RecentFileManager.getInstance().macrosLoaded(wbFile);
        this.setTooltip(wbFile.getFullPath());
    }

    @Override
    public void macroListChanged() {
        EventQueue.invokeLater(() -> {
            MacroStorage macroStorage = MacroManager.getInstance().getMacros(this.macroClientId);
            if (macroStorage != null) {
                String string = macroStorage.getCurrentMacroFilename();
                this.setTooltip(string);
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        MacroManager.getInstance().removeChangeListener(this, this.macroClientId);
    }
}

