/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbTable;
import workbench.gui.filter.SelectionFilter;

public class SelectionFilterAction
extends WbAction
implements ListSelectionListener {
    private WbTable client;

    public SelectionFilterAction() {
        this.initMenuDefinition("MnuTxtColFilter");
        this.setIcon("colfilter");
        this.setMenuItemName("MnuTxtData");
        this.setEnabled(false);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        SelectionFilter selectionFilter = new SelectionFilter(this.client);
        selectionFilter.applyFilter();
    }

    public void setClient(WbTable wbTable) {
        ListSelectionModel listSelectionModel;
        if (this.client != null && (listSelectionModel = this.client.getSelectionModel()) != null) {
            listSelectionModel.removeListSelectionListener(this);
        }
        this.client = wbTable;
        this.setEnabled(this.client != null);
        if (this.client != null && (listSelectionModel = this.client.getSelectionModel()) != null) {
            listSelectionModel.addListSelectionListener(this);
        }
        this.checkEnabled();
    }

    private void checkEnabled() {
        if (this.client == null) {
            this.setEnabled(false);
        } else {
            int n = this.client.getSelectedRowCount();
            int n2 = this.client.getSelectedColumnCount();
            this.setEnabled(n == 1 || n > 1 && n2 == 1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkEnabled();
    }
}

