/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import workbench.gui.MainWindow;
import workbench.gui.actions.WbAction;
import workbench.gui.macros.MacroPopup;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class ShowMacroPopupAction
extends WbAction
implements WindowFocusListener,
WindowListener {
    private MainWindow client;
    private MacroPopup macroWindow;

    public ShowMacroPopupAction(MainWindow mainWindow) {
        this.client = mainWindow;
        this.initMenuDefinition("MnuTxtMacroPopup");
        this.setMenuItemName("MnuTxtSQL");
        this.setIcon(null);
        this.setEnabled(true);
    }

    public boolean isPopupVisible() {
        return this.macroWindow != null && this.macroWindow.isVisible();
    }

    public void showPopup() {
        try {
            this.createPopup();
            this.macroWindow.setVisible(true);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not display macro popup", throwable);
        }
    }

    public void saveWorkspaceSettings() {
        if (this.macroWindow != null) {
            this.macroWindow.saveWorkspaceSettings();
        }
    }

    public void workspaceChanged() {
        if (this.macroWindow != null) {
            this.macroWindow.workspaceChanged();
        }
    }

    private void createPopup() {
        if (this.macroWindow == null) {
            this.macroWindow = new MacroPopup(this.client);
            this.client.addWindowFocusListener(this);
            this.macroWindow.addWindowListener(this);
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.showPopup();
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        if (this.macroWindow != null && windowEvent.getWindow() == this.client && !this.macroWindow.isShowing() && !this.macroWindow.isClosing()) {
            this.macroWindow.setVisible(true);
            this.client.requestFocus();
            EventQueue.invokeLater(this.client::requestEditorFocus);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        if (this.macroWindow != null && windowEvent.getOppositeWindow() != this.macroWindow && (windowEvent.getOppositeWindow() == null || windowEvent.getOppositeWindow() != null && windowEvent.getOppositeWindow().getOwner() != this.client) && !this.macroWindow.isClosing()) {
            this.macroWindow.setVisible(false);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this.macroWindow) {
            this.client.removeWindowFocusListener(this);
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this.macroWindow) {
            this.macroWindow.removeWindowListener(this);
            this.macroWindow = null;
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this.macroWindow && windowEvent.getOppositeWindow() != this.client && this.macroWindow.isShowing() && !this.macroWindow.isClosing()) {
            this.macroWindow.setVisible(false);
        }
    }
}

