/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import workbench.db.GenericObjectDropper;
import workbench.db.IndexDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.objectcache.Namespace;
import workbench.gui.completion.BaseAnalyzer;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class DdlAnalyzer
extends BaseAnalyzer {
    public static final String DDL_TYPES_FILE = "ddl_types.txt";

    public DdlAnalyzer(WbConnection wbConnection, String string, int n) {
        super(wbConnection, string, n);
    }

    @Override
    protected void checkContext() {
        Object object;
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.dbConnection, this.sql);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken == null) {
            this.context = -1;
            return;
        }
        String string = sQLToken.getContents();
        if ("TRUNCATE".equalsIgnoreCase(string)) {
            this.context = 1;
            return;
        }
        SQLToken sQLToken2 = sQLLexer.getNextToken(false, false);
        String string2 = sQLToken2 != null ? sQLToken2.getContents() : null;
        SQLToken sQLToken3 = sQLLexer.getNextToken(false, false);
        String string3 = null;
        if (sQLToken3 != null) {
            object = new TableIdentifier(sQLToken3.getContents());
            this.namespaceForTableList = Namespace.fromTable((TableIdentifier)object, this.dbConnection);
            string3 = ((TableIdentifier)object).getTableName();
            if (StringUtil.isEmptyString(string3)) {
                string3 = null;
            }
        }
        if (this.namespaceForTableList == null) {
            this.namespaceForTableList = this.getNamespaceFromCurrentWord();
        }
        object = this.dbConnection.getMetadata().getMViewTypeName();
        if ("DROP".equals(string)) {
            boolean bl;
            if (string2 == null || this.between(this.cursorPos, sQLToken.getCharEnd(), sQLToken2.getCharBegin())) {
                this.context = 5;
                this.keywordFile = DDL_TYPES_FILE;
            }
            boolean bl2 = sQLToken2 != null && this.cursorPos >= sQLToken2.getCharEnd() && (sQLToken3 == null || string3 == null && this.cursorPos == sQLToken3.getCharEnd());
            boolean bl3 = bl = sQLToken3 != null && this.cursorPos > sQLToken3.getCharEnd();
            if ("TABLE".equals(string2)) {
                if (bl2) {
                    this.context = 1;
                    this.setTableTypeFilter(this.dbConnection.getMetadata().getTableTypes());
                } else if (bl) {
                    this.context = 5;
                    this.keywordFile = "table.drop_options.txt";
                }
            } else if ("INDEX".equals(string2) && bl2) {
                this.context = 14;
            } else if ("VIEW".equals(string2) && bl2) {
                this.context = 1;
                this.setTableTypeFilter(this.dbConnection.getDbSettings().getViewTypes());
            } else if (string2.equalsIgnoreCase((String)object) && bl2) {
                this.context = 1;
                this.setTableTypeFilter(CollectionUtil.arrayList(object));
            } else if (this.isDropSchema(string2)) {
                if (bl2) {
                    this.context = 11;
                } else if (bl) {
                    this.context = 5;
                    this.keywordFile = string2.trim().toLowerCase() + ".drop_options.txt";
                }
            } else if ("DATABASE".equals(string2) && bl2) {
                this.context = 12;
            } else if ("SEQUENCE".equals(string2) && bl2) {
                if (bl2) {
                    this.context = 13;
                } else if (bl) {
                    this.context = 5;
                    this.keywordFile = "sequence.drop_options.txt";
                }
            }
        } else {
            this.context = -1;
        }
    }

    private boolean isDropSchema(String string) {
        return "SCHEMA".equalsIgnoreCase(string) || this.dbConnection.getMetadata().isOracle() && "USER".equalsIgnoreCase(string);
    }

    @Override
    public String getPasteValue(Object object) {
        if (object instanceof IndexDefinition) {
            IndexDefinition indexDefinition = (IndexDefinition)object;
            indexDefinition = indexDefinition.createCopy();
            if (StringUtil.equalStringIgnoreCase(this.namespaceForTableList.getSchema(), indexDefinition.getSchema())) {
                indexDefinition.setSchema(null);
                indexDefinition.getBaseTable().setSchema(null);
            }
            if (StringUtil.equalStringIgnoreCase(this.namespaceForTableList.getCatalog(), indexDefinition.getCatalog())) {
                indexDefinition.setCatalog(null);
                indexDefinition.getBaseTable().setCatalog(null);
            }
            GenericObjectDropper genericObjectDropper = new GenericObjectDropper();
            genericObjectDropper.setConnection(this.dbConnection);
            genericObjectDropper.setObjectTable(indexDefinition.getBaseTable());
            String string = genericObjectDropper.getDropForObject(indexDefinition).toString();
            return string.replaceFirst("(?i)drop\\s+index\\s+", "");
        }
        return null;
    }

    @Override
    public boolean needsCommaForMultipleSelection() {
        return this.context != 5;
    }
}

