/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import workbench.db.WbConnection;
import workbench.gui.completion.BaseAnalyzer;
import workbench.gui.completion.ExplainAnalyzer;
import workbench.gui.completion.MySQLExplainAnalyzer;
import workbench.gui.completion.OracleExplainAnalyzer;
import workbench.gui.completion.PostgresExplainAnalyzer;
import workbench.gui.completion.StatementContext;

public class ExplainAnalyzerFactory {
    public BaseAnalyzer getAnalyzer(WbConnection wbConnection, String string, int n) {
        ExplainAnalyzer explainAnalyzer = null;
        if (wbConnection.getMetadata().isOracle()) {
            explainAnalyzer = new OracleExplainAnalyzer(wbConnection, string, n);
        } else if (wbConnection.getMetadata().isPostgres()) {
            explainAnalyzer = new PostgresExplainAnalyzer(wbConnection, string, n);
        } else if (wbConnection.getMetadata().isMySql()) {
            explainAnalyzer = new MySQLExplainAnalyzer(wbConnection, string, n);
        } else {
            return null;
        }
        int n2 = explainAnalyzer.getStatementStart(string);
        if (n >= n2) {
            StatementContext statementContext = new StatementContext(wbConnection, explainAnalyzer.getExplainedStatement(), n - n2, false);
            return statementContext.getAnalyzer();
        }
        return explainAnalyzer;
    }
}

