/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import workbench.WbManager;
import workbench.console.ConsolePrinter;
import workbench.console.DataStorePrinter;
import workbench.console.TextPrinter;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.ExportType;
import workbench.db.exporter.RowDataConverter;
import workbench.db.exporter.SqlRowDataConverter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ColumnSelectionResult;
import workbench.gui.components.ColumnSelectorPanel;
import workbench.gui.components.DbUnitCopier;
import workbench.gui.components.StringSelectionAdapter;
import workbench.gui.components.UpdateTableSelector;
import workbench.gui.components.WbTable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.MultiRowInserts;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataPrinter;
import workbench.storage.DataStore;
import workbench.storage.RowData;
import workbench.util.CharacterRange;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class ClipBoardCopier {
    private final DataStore data;
    private final WbTable client;

    public ClipBoardCopier(WbTable wbTable) {
        this.client = wbTable;
        this.data = this.client.getDataStore();
    }

    ClipBoardCopier(DataStore dataStore) {
        this.client = null;
        this.data = dataStore;
    }

    public void copyDataToClipboard(boolean bl, boolean bl2, boolean bl3) {
        if (this.data == null) {
            WbSwingUtilities.showErrorMessage(this.client, "No DataStore available!");
            LogMgr.logError(new CallerInfo(){}, "Cannot copy without a DataStore!", null);
            return;
        }
        if (this.data.getRowCount() <= 0) {
            return;
        }
        List<ColumnIdentifier> list = null;
        if (bl2 && !bl3 && this.client != null && this.client.getColumnSelectionAllowed()) {
            list = this.getColumnsFromSelection();
        }
        boolean bl4 = false;
        if (bl3 && this.client != null) {
            ColumnSelectionResult columnSelectionResult = this.selectColumns(bl, bl2, true, this.client.getSelectedRowCount() > 0, true);
            if (columnSelectionResult == null) {
                return;
            }
            list = columnSelectionResult.columns;
            bl = columnSelectionResult.includeHeaders;
            bl2 = columnSelectionResult.selectedOnly;
            bl4 = columnSelectionResult.formatText;
        }
        try {
            Object object;
            Object object2;
            int n = this.data.getRowCount();
            int[] nArray = null;
            if (bl2) {
                nArray = this.client == null ? null : this.client.getSelectedRows();
                n = nArray == null ? 0 : nArray.length;
            }
            boolean bl5 = Settings.getInstance().copyToClipboardAsHtml();
            StringWriter stringWriter = new StringWriter(n * 250);
            if (bl4) {
                bl5 = false;
                object2 = new DataStorePrinter(this.data);
                ((ConsolePrinter)object2).setNullString(GuiSettings.getDisplayNullString());
                ((ConsolePrinter)object2).setFormatColumns(true);
                ((ConsolePrinter)object2).setPrintRowCount(false);
                ((ConsolePrinter)object2).setShowResultName(GuiSettings.copyToClipboardFormattedTextWithResultName());
                if (list != null) {
                    object = new ArrayList(list.size());
                    for (ColumnIdentifier columnIdentifier : list) {
                        object.add(columnIdentifier.getColumnName());
                    }
                    ((ConsolePrinter)object2).setColumnsToPrint((Collection<String>)object);
                }
                object = TextPrinter.createPrinter(new PrintWriter(stringWriter));
                ((DataStorePrinter)object2).printTo((TextPrinter)object, nArray);
            } else {
                object2 = new DataPrinter(this.data, "\t", "\n", list, bl);
                object = Settings.getInstance().getProperty("workbench.copy.text.escaperange", CharacterRange.RANGE_NONE.getName());
                CharacterRange characterRange = CharacterRange.getRangeByName((String)object);
                ((DataPrinter)object2).setEscapeRange(characterRange);
                ((DataPrinter)object2).setNullString(GuiSettings.getDisplayNullString());
                ((DataPrinter)object2).setColumnMapping(this.getColumnOrder());
                ((DataPrinter)object2).writeDataString(stringWriter, nArray);
            }
            WbSwingUtilities.showWaitCursorOnWindow(this.client);
            object2 = this.getClipboard();
            object = new StringSelectionAdapter(stringWriter.toString(), bl5);
            ((Clipboard)object2).setContents((Transferable)object, (ClipboardOwner)object);
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                WbManager.getInstance().showOutOfMemoryError();
            } else {
                String string = ResourceMgr.getString("ErrClipCopy");
                string = StringUtil.replace(string, "%errmsg%", ExceptionUtil.getDisplay(throwable));
                WbSwingUtilities.showErrorMessage(this.client, string);
            }
            LogMgr.logError(new CallerInfo(){}, "Could not copy text data to clipboard", throwable);
        }
        WbSwingUtilities.showDefaultCursorOnWindow(this.client);
    }

    protected Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    private int[] getColumnOrder() {
        if (this.client == null) {
            return null;
        }
        if (!this.client.isColumnOrderChanged()) {
            return null;
        }
        TableColumnModel tableColumnModel = this.client.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray[i] = n2 = tableColumnModel.getColumn(i).getModelIndex();
        }
        return nArray;
    }

    public void copyAsSqlInsert(boolean bl, boolean bl2) {
        this.copyAsSql(ExportType.SQL_INSERT, bl, bl2);
    }

    public void copyAsDbUnit(final boolean bl, final boolean bl2) {
        if (this.data == null) {
            WbSwingUtilities.showErrorMessage(this.client, "No DataStore available!");
            LogMgr.logError(new CallerInfo(){}, "Cannot copy without a DataStore!", null);
            return;
        }
        WbThread wbThread = new WbThread("CopyThread"){

            @Override
            public void run() {
                ClipBoardCopier.this.doCopyAsDBUnitXML(bl, bl2);
            }
        };
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopyAsDBUnitXML(boolean bl, boolean bl2) {
        if (this.data == null) {
            return;
        }
        this.checkUpdateTable();
        try {
            String string;
            WbSwingUtilities.showWaitCursorOnWindow(this.client);
            DbUnitCopier dbUnitCopier = new DbUnitCopier();
            int[] nArray = null;
            if (bl && this.client != null) {
                nArray = this.client.getSelectedRows();
            }
            if ((string = dbUnitCopier.createDBUnitXMLDataString(this.data, nArray)) != null) {
                Clipboard clipboard = this.getClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                WbManager.getInstance().showOutOfMemoryError();
            } else {
                String string = ResourceMgr.getString("ErrClipCopy");
                string = StringUtil.replace(string, "%errmsg%", ExceptionUtil.getDisplay(throwable));
                if (!WbManager.isTest()) {
                    WbSwingUtilities.showErrorMessage(this.client, string);
                }
            }
            LogMgr.logError(new CallerInfo(){}, "Error when copying as SQL", throwable);
        }
        finally {
            WbSwingUtilities.showDefaultCursorOnWindow(this.client);
        }
    }

    public void copyAsSqlDeleteInsert(boolean bl, boolean bl2) {
        this.copyAsSql(ExportType.SQL_DELETE_INSERT, bl, bl2);
    }

    public void copyAsSqlDelete(boolean bl, boolean bl2) {
        this.copyAsSql(ExportType.SQL_DELETE, bl, bl2);
    }

    public void copyAsSqlUpdate(boolean bl, boolean bl2) {
        this.copyAsSql(ExportType.SQL_UPDATE, bl, bl2);
    }

    public void copyAsSql(final ExportType exportType, final boolean bl, final boolean bl2) {
        if (this.data == null) {
            WbSwingUtilities.showErrorMessage(this.client, "No DataStore available!");
            LogMgr.logError(new CallerInfo(){}, "Cannot copy without a DataStore!", null);
            return;
        }
        WbThread wbThread = new WbThread("CopyThread"){

            @Override
            public void run() {
                ClipBoardCopier.this.doCopyAsSql(exportType, bl, bl2);
            }
        };
        wbThread.start();
    }

    private boolean needsPK(ExportType exportType) {
        return exportType == ExportType.SQL_UPDATE || exportType == ExportType.SQL_MERGE || exportType == ExportType.SQL_DELETE_INSERT;
    }

    public void doCopyAsSql(ExportType exportType, boolean bl, boolean bl2) {
        String string = this.createSqlString(exportType, bl, bl2);
        if (string != null) {
            Clipboard clipboard = this.getClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    private boolean supportsMultiRowInserts() {
        if (this.data == null) {
            return false;
        }
        if (this.data.getOriginalConnection() == null) {
            return false;
        }
        return this.data.getOriginalConnection().getDbSettings().supportsMultiRowInsert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSqlString(ExportType exportType, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        if (this.data.getRowCount() <= 0) {
            return null;
        }
        if (this.needsPK(exportType)) {
            boolean bl3 = this.data.hasPkColumns();
            if (!bl3 && this.client != null) {
                this.client.checkPkColumns(true);
            }
            if (!(bl3 = this.data.hasPkColumns())) {
                LogMgr.logError(new CallerInfo(){}, "Cannot create UPDATE or DELETE statements without a primary key!", null);
                if (!WbManager.isTest()) {
                    WbSwingUtilities.showErrorMessageKey(this.client, "ErrCopyNotAvailable");
                }
                return null;
            }
        }
        this.checkUpdateTable();
        List<ColumnIdentifier> list = null;
        if (bl && !bl2 && this.client.getColumnSelectionAllowed()) {
            list = this.getColumnsFromSelection();
        }
        if (bl2 && !WbManager.isTest()) {
            object2 = this.selectColumns(false, bl, false, this.client.getSelectedRowCount() > 0, false);
            if (object2 == null) {
                return null;
            }
            list = ((ColumnSelectionResult)object2).columns;
            bl = ((ColumnSelectionResult)object2).selectedOnly;
        }
        if (exportType == ExportType.SQL_UPDATE) {
            object2 = new ArrayList();
            for (ColumnIdentifier comparable : this.data.getResultInfo().getColumns()) {
                if (!comparable.isPkColumn()) continue;
                object2.add(comparable);
            }
            if (list != null && list.size() == object2.size() && list.containsAll((Collection<?>)object2)) {
                LogMgr.logError(new CallerInfo(){}, "Cannot create UPDATE statement with only key columns!", null);
                if (!WbManager.isTest()) {
                    WbSwingUtilities.showErrorMessageKey(this.client, "ErrCopyNoNonKeyCols");
                }
                return null;
            }
        }
        try {
            CharSequence charSequence;
            if (!WbManager.isTest()) {
                WbSwingUtilities.showWaitCursorOnWindow(this.client);
            }
            object2 = null;
            if (bl) {
                object2 = this.client.getSelectedRows();
            }
            object = new SqlRowDataConverter(this.data.getOriginalConnection());
            ((SqlRowDataConverter)object).setIncludeTableOwner(Settings.getInstance().getIncludeOwnerInSqlExport());
            ((SqlRowDataConverter)object).setDateLiteralType(Settings.getInstance().getDefaultCopyDateLiteralType());
            ((SqlRowDataConverter)object).setType(exportType);
            MultiRowInserts multiRowInserts = Settings.getInstance().getUseMultirowInsertForClipboard();
            switch (multiRowInserts) {
                case never: {
                    ((SqlRowDataConverter)object).setUseMultiRowInserts(false);
                    break;
                }
                case always: {
                    ((SqlRowDataConverter)object).setUseMultiRowInserts(true);
                    break;
                }
                default: {
                    ((SqlRowDataConverter)object).setUseMultiRowInserts(this.supportsMultiRowInserts());
                }
            }
            ((SqlRowDataConverter)object).setTransactionControl(false);
            ((SqlRowDataConverter)object).setIgnoreColumnStatus(true);
            switch (exportType) {
                case SQL_INSERT: 
                case SQL_DELETE_INSERT: 
                case SQL_INSERT_IGNORE: {
                    ((SqlRowDataConverter)object).setApplySQLFormatting(Settings.getInstance().getDoFormatInserts());
                }
                case SQL_UPDATE: {
                    ((SqlRowDataConverter)object).setApplySQLFormatting(Settings.getInstance().getDoFormatUpdates());
                }
                case SQL_DELETE: {
                    ((SqlRowDataConverter)object).setApplySQLFormatting(Settings.getInstance().getDoFormatDeletes());
                }
            }
            ((SqlRowDataConverter)object).setApplySQLFormatting(false);
            if (list != null) {
                ((SqlRowDataConverter)object).setIncludeIdentityColumns(true);
                ((SqlRowDataConverter)object).setIncludeReadOnlyColumns(true);
            }
            ((SqlRowDataConverter)object).setResultInfo(this.data.getResultInfo());
            if ((exportType == ExportType.SQL_INSERT || exportType == ExportType.SQL_DELETE_INSERT) && this.data.getResultInfo().getUpdateTable() == null) {
                String string = this.data.getInsertTable();
                TableIdentifier tableIdentifier = new TableIdentifier(string, this.data.getOriginalConnection());
                ((SqlRowDataConverter)object).setAlternateUpdateTable(tableIdentifier);
            }
            ((RowDataConverter)object).setColumnsToExport(list);
            ((SqlRowDataConverter)object).setBlobMode(BlobMode.DbmsLiteral);
            int n = object2 != null ? ((Object)object2).length : this.data.getRowCount();
            StringBuilder stringBuilder = new StringBuilder(n * 100);
            RowData rowData = null;
            StringBuilder stringBuilder2 = ((SqlRowDataConverter)object).getStart();
            if (stringBuilder2 != null) {
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            for (int i = 0; i < n; ++i) {
                rowData = object2 == null ? this.data.getRow(i) : this.data.getRow((int)object2[i]);
                charSequence = ((SqlRowDataConverter)object).convertRowData(rowData, i);
                stringBuilder.append(charSequence);
                boolean bl3 = false;
                if (exportType == ExportType.SQL_INSERT) {
                    bl3 = !((SqlRowDataConverter)object).getUseMultiRowInserts();
                } else {
                    boolean bl4 = bl3 = exportType != ExportType.SQL_MERGE && !StringUtil.endsWith(charSequence, '\n');
                }
                if (!bl3) continue;
                stringBuilder.append('\n');
            }
            StringBuilder stringBuilder3 = ((SqlRowDataConverter)object).getEnd(n);
            if (stringBuilder3 != null) {
                stringBuilder.append((CharSequence)stringBuilder3);
            }
            charSequence = stringBuilder.toString();
            return charSequence;
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                WbManager.getInstance().showOutOfMemoryError();
            } else {
                object = ResourceMgr.getString("ErrClipCopy");
                object = StringUtil.replace((String)object, "%errmsg%", ExceptionUtil.getDisplay(throwable));
                if (!WbManager.isTest()) {
                    WbSwingUtilities.showErrorMessage(this.client, (String)object);
                }
            }
            LogMgr.logError(new CallerInfo(){}, "Error when copying as SQL", throwable);
        }
        finally {
            if (!WbManager.isTest()) {
                WbSwingUtilities.showDefaultCursorOnWindow(this.client);
            }
        }
        return null;
    }

    public ColumnSelectionResult selectColumns(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (this.data == null) {
            return null;
        }
        ColumnSelectionResult columnSelectionResult = new ColumnSelectionResult();
        columnSelectionResult.includeHeaders = bl;
        columnSelectionResult.selectedOnly = bl2;
        ColumnIdentifier[] columnIdentifierArray = this.data.getColumns();
        ColumnSelectorPanel columnSelectorPanel = new ColumnSelectorPanel(columnIdentifierArray, bl, bl2, bl3, bl4, bl5);
        columnSelectorPanel.restoreSettings("clipboardcopy");
        columnSelectorPanel.selectAll();
        boolean bl6 = WbSwingUtilities.getOKCancel(ResourceMgr.getString("MsgSelectColumnsWindowTitle"), SwingUtilities.getWindowAncestor(this.client), columnSelectorPanel);
        if (bl6) {
            columnSelectionResult.columns = columnSelectorPanel.getSelectedColumns();
            columnSelectionResult.includeHeaders = columnSelectorPanel.includeHeader();
            columnSelectionResult.selectedOnly = columnSelectorPanel.selectedOnly();
            columnSelectionResult.formatText = columnSelectorPanel.formatTextOutput();
        } else {
            columnSelectionResult = null;
        }
        columnSelectorPanel.saveSettings("clipboardcopy");
        return columnSelectionResult;
    }

    private void checkUpdateTable() {
        UpdateTableSelector updateTableSelector;
        if (this.data == null) {
            return;
        }
        TableIdentifier tableIdentifier = this.data.getUpdateTable();
        if (tableIdentifier == null && this.client != null && (tableIdentifier = (updateTableSelector = new UpdateTableSelector(this.client)).selectUpdateTable()) != null) {
            this.client.getDataStore().setUpdateTable(tableIdentifier);
        }
    }

    private List<ColumnIdentifier> getColumnsFromSelection() {
        int[] nArray = this.client.getSelectedColumns();
        DataStore dataStore = this.client.getDataStore();
        if (dataStore == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(nArray.length);
        TableColumnModel tableColumnModel = this.client.getColumnModel();
        for (int i = 0; i < nArray.length; ++i) {
            int n = tableColumnModel.getColumn(nArray[i]).getModelIndex();
            arrayList.add(dataStore.getResultInfo().getColumn(n));
        }
        return arrayList;
    }
}

