/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import workbench.db.ColumnIdentifier;
import workbench.gui.components.ColumnSelectTableModel;
import workbench.gui.components.WbScrollPane;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class ColumnSelectorPanel
extends JPanel
implements ActionListener {
    private JTable columnTable;
    protected JPanel infoPanel;
    private ColumnSelectTableModel model;
    private JButton selectAll;
    private JButton selectNone;
    private JCheckBox selectedOnlyCheckBox;
    private JCheckBox includeHeaderCheckBox;
    private JCheckBox formatText;

    public ColumnSelectorPanel(ColumnIdentifier[] columnIdentifierArray) {
        this(columnIdentifierArray, false, false, false, false, false);
    }

    public ColumnSelectorPanel(ColumnIdentifier[] columnIdentifierArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.setLayout(new GridBagLayout());
        this.columnTable = new JTable();
        this.columnTable.setRowSelectionAllowed(false);
        this.columnTable.setColumnSelectionAllowed(false);
        this.model = new ColumnSelectTableModel(columnIdentifierArray);
        this.columnTable.setModel(this.model);
        this.adjustColumnWidths();
        WbScrollPane wbScrollPane = new WbScrollPane(this.columnTable);
        this.infoPanel = new JPanel(new FlowLayout(3));
        this.configureInfoPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.infoPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)wbScrollPane, gridBagConstraints);
        this.selectAll = new JButton(ResourceMgr.getString("LblSelectAll"));
        this.selectNone = new JButton(ResourceMgr.getString("LblSelectNone"));
        this.selectAll.addActionListener(this);
        this.selectNone.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        jPanel.add((Component)this.selectAll, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)this.selectNone, gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        if (bl4) {
            this.selectedOnlyCheckBox = new JCheckBox(ResourceMgr.getString("LblSelectedRowsOnly"));
            this.selectedOnlyCheckBox.setSelected(bl2);
            this.selectedOnlyCheckBox.setEnabled(true);
            jPanel2.add(this.selectedOnlyCheckBox);
        }
        if (bl3) {
            this.includeHeaderCheckBox = new JCheckBox(ResourceMgr.getString("LblExportIncludeHeaders"));
            this.includeHeaderCheckBox.setSelected(bl);
            jPanel2.add(this.includeHeaderCheckBox);
        }
        if (bl5) {
            this.formatText = new JCheckBox(ResourceMgr.getString("LblCopyFormatTxt"));
            this.formatText.setToolTipText(ResourceMgr.getDescription("LblCopyFormatTxt"));
            jPanel2.add(this.formatText);
        }
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 10, 0);
        this.add((Component)jPanel, gridBagConstraints);
        this.columnTable.setAutoResizeMode(0);
        Dimension dimension = wbScrollPane.getPreferredSize();
        int n = Math.min(10, this.columnTable.getRowCount() + 4);
        int n2 = this.columnTable.getRowHeight() * n + this.columnTable.getRowCount() * this.columnTable.getRowMargin();
        Dimension dimension2 = new Dimension(dimension.width, (int)((double)n2 * 1.1));
        wbScrollPane.setPreferredSize(dimension2);
    }

    public void restoreSettings(String string) {
        if (StringUtil.isBlank(string)) {
            return;
        }
        Settings settings = Settings.getInstance();
        String string2 = "workbench.gui.columnselector." + string.toLowerCase() + ".";
        if (this.formatText != null) {
            this.formatText.setSelected(settings.getBoolProperty(string2 + "formattext", false));
        }
        if (this.includeHeaderCheckBox != null) {
            this.includeHeaderCheckBox.setSelected(settings.getBoolProperty(string2 + "includeheader", false));
        }
        if (this.selectedOnlyCheckBox != null) {
            this.selectedOnlyCheckBox.setSelected(settings.getBoolProperty(string2 + "selectedonly", false));
        }
    }

    public void saveSettings(String string) {
        if (StringUtil.isBlank(string)) {
            return;
        }
        Settings settings = Settings.getInstance();
        String string2 = "workbench.gui.columnselector." + string.toLowerCase() + ".";
        if (this.formatText != null) {
            settings.setProperty(string2 + "formattext", this.formatTextOutput());
        }
        if (this.includeHeaderCheckBox != null) {
            settings.setProperty(string2 + "includeheader", this.includeHeader());
        }
        if (this.selectedOnlyCheckBox != null) {
            settings.setProperty(string2 + "selectedonly", this.selectedOnly());
        }
    }

    private void adjustColumnWidths() {
        Font font = this.columnTable.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = this.columnTable.getFontMetrics(font);
        if (fontMetrics == null) {
            return;
        }
        int n = fontMetrics.stringWidth("M") * 40;
        int n2 = fontMetrics.stringWidth("M") * 5;
        TableColumnModel tableColumnModel = this.columnTable.getColumnModel();
        int n3 = this.columnTable.getIntercellSpacing().width + 4 + tableColumnModel.getColumnMargin();
        int n4 = (int)((double)this.calculateColumnWidths(0, n2, n, n3, fontMetrics, true) * 1.15);
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(n4);
        n4 = (int)((double)this.calculateColumnWidths(1, n2, n, n3, fontMetrics, false) * 1.15);
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setPreferredWidth(n4);
        this.columnTable.getTableHeader().setReorderingAllowed(false);
    }

    private int calculateColumnWidths(int n, int n2, int n3, int n4, FontMetrics fontMetrics, boolean bl) {
        int n5 = this.columnTable.getRowCount();
        String string = this.columnTable.getColumnName(n);
        int n6 = Math.max(n2, fontMetrics.stringWidth(string));
        if (!bl) {
            return n6 + n4;
        }
        for (int i = 0; i < n5; ++i) {
            int n7 = 0;
            Object object = this.columnTable.getValueAt(i, n);
            if (object != null) {
                String string2 = object.toString();
                n7 = fontMetrics.stringWidth(string2);
            }
            n6 = Math.max(n6, n7 + n4);
        }
        if (n3 > 0) {
            n6 = Math.min(n6, n3);
        }
        return n6;
    }

    protected void configureInfoPanel() {
        this.infoPanel.add((Component)new JLabel(ResourceMgr.getString("MsgSelectColumns")), "Before");
    }

    public void setSelectionLabel(String string) {
        this.model.selectLabel = string;
        TableColumnModel tableColumnModel = this.columnTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setHeaderValue(string);
    }

    public boolean formatTextOutput() {
        if (this.formatText == null) {
            return false;
        }
        return this.formatText.isSelected();
    }

    public boolean selectedOnly() {
        if (this.selectedOnlyCheckBox == null) {
            return false;
        }
        return this.selectedOnlyCheckBox.isSelected();
    }

    public boolean includeHeader() {
        if (this.includeHeaderCheckBox == null) {
            return false;
        }
        return this.includeHeaderCheckBox.isSelected();
    }

    public boolean isColumnSelected(int n) {
        return this.model.selected[n];
    }

    public int getSelectedCount() {
        int n = 0;
        for (int i = 0; i < this.model.selected.length; ++i) {
            if (!this.model.selected[i]) continue;
            ++n;
        }
        return n;
    }

    public List<ColumnIdentifier> getSelectedColumns() {
        int n = this.getSelectedCount();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(n);
        for (int i = 0; i < this.model.selected.length; ++i) {
            if (!this.model.selected[i]) continue;
            arrayList.add(this.model.columns[i].createCopy());
        }
        return arrayList;
    }

    public void selectAll() {
        this.model.selectAll();
    }

    public void selectNone() {
        this.model.selectNone();
    }

    public void setColumnSelected(int n, boolean bl) {
        this.model.selected[n] = bl;
    }

    public void selectColumns(List list) {
        if (list == null) {
            this.selectAll();
        } else {
            int n = this.model.columns.length;
            for (int i = 0; i < n; ++i) {
                this.model.selected[i] = list.contains(this.model.columns[i]);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.model == null) {
            return;
        }
        if (actionEvent.getSource() == this.selectAll) {
            this.model.selectAll();
        } else if (actionEvent.getSource() == this.selectNone) {
            this.model.selectNone();
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this.model);
        this.columnTable.tableChanged(tableModelEvent);
    }
}

