/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.NoConnectionException;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FeedbackWindow;
import workbench.gui.profiles.ProfileSelectionDialog;
import workbench.interfaces.Connectable;
import workbench.interfaces.StatusBar;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.ExceptionUtil;
import workbench.util.GlobalPasswordManager;
import workbench.util.ImageUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class ConnectionSelector
implements StatusBar {
    protected Connectable client;
    private boolean connectInProgress;
    protected Frame parent;
    protected FeedbackWindow connectingInfo;
    private String propertyKey;

    public ConnectionSelector(Frame frame, Connectable connectable) {
        this.client = connectable;
        this.parent = frame;
    }

    public void setPropertyKey(String string) {
        this.propertyKey = string;
    }

    public boolean isConnectInProgress() {
        return this.connectInProgress;
    }

    public void selectConnection() {
        WbSwingUtilities.invoke(this::_selectConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _selectConnection() {
        if (this.isConnectInProgress()) {
            return;
        }
        if (!GlobalPasswordManager.getInstance().showPasswordPromptIfNeeded()) {
            return;
        }
        Window window = null;
        try {
            WbSwingUtilities.showWaitCursor(this.parent);
            window = new ProfileSelectionDialog(this.parent, true, this.propertyKey);
            WbSwingUtilities.center(window, this.parent);
            WbSwingUtilities.showDefaultCursor(this.parent);
            ((Dialog)window).setVisible(true);
            ConnectionProfile connectionProfile = ((ProfileSelectionDialog)window).getSelectedProfile();
            boolean bl = ((ProfileSelectionDialog)window).isCancelled();
            if (bl || connectionProfile == null) {
                this.client.connectCancelled();
            } else {
                this.connectTo(connectionProfile, false, true);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error during connect", throwable);
        }
        finally {
            if (window != null) {
                window.dispose();
            }
        }
    }

    public void connectTo(final ConnectionProfile connectionProfile, final boolean bl, final boolean bl2) {
        if (this.isConnectInProgress()) {
            LogMgr.logWarning(new CallerInfo(){}, "connectTo() called while a connect is still in progress");
            return;
        }
        WbThread wbThread = new WbThread("Connection thread"){

            @Override
            public void run() {
                ConnectionSelector.this.doConnect(connectionProfile, bl, bl2);
            }
        };
        wbThread.start();
    }

    public void closeConnectingInfo() {
        WbSwingUtilities.invoke(() -> {
            if (this.connectingInfo != null) {
                this.connectingInfo.setVisible(false);
                this.connectingInfo.dispose();
                this.connectingInfo = null;
                WbSwingUtilities.repaintLater(this.parent);
            }
        });
    }

    public void showDisconnectInfo() {
        this.showPopupMessagePanel(ResourceMgr.getString("MsgDisconnecting"));
    }

    public void showConnectingInfo() {
        this.showPopupMessagePanel(ResourceMgr.getString("MsgConnecting"));
    }

    protected void showPopupMessagePanel(String string) {
        WbSwingUtilities.invoke(() -> {
            if (this.connectingInfo != null) {
                this.connectingInfo.setMessage(string);
                this.connectingInfo.pack();
                WbSwingUtilities.center(this.connectingInfo, this.parent);
            } else {
                this.connectingInfo = new FeedbackWindow(this.parent, string);
                WbSwingUtilities.center(this.connectingInfo, this.parent);
                this.connectingInfo.setVisible(true);
            }
            this.connectingInfo.forceRepaint();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect(ConnectionProfile connectionProfile, boolean bl, boolean bl2) {
        CharSequence charSequence;
        Object object;
        if (this.isConnectInProgress()) {
            LogMgr.logWarning(new CallerInfo(){}, "doConnect() called while a connect is still in progress");
            return;
        }
        List<File> list = ImageUtil.getIcons(connectionProfile.getIcon());
        if (list.size() > 0) {
            try {
                ResourceMgr.setWindowIcons((Window)this.parent, list);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not set window icon", throwable);
                ResourceMgr.setWindowIcons((Window)this.parent, "workbench");
            }
        } else {
            ResourceMgr.setWindowIcons((Window)this.parent, this.client.getDefaultIconName());
        }
        WbConnection wbConnection = null;
        String string = null;
        if (!this.client.connectBegin(connectionProfile, this, bl2)) {
            this.closeConnectingInfo();
            return;
        }
        this.setConnectIsInProgress();
        this.showConnectingInfo();
        String string2 = this.client.getConnectionId(connectionProfile);
        try {
            object = ConnectionMgr.getInstance();
            WbSwingUtilities.showWaitCursor(this.parent);
            wbConnection = ((ConnectionMgr)object).getConnection(connectionProfile, string2);
            if (this.propertyKey != null) {
                Settings.getInstance().setProperty(this.propertyKey, connectionProfile.getName());
            }
        }
        catch (NoConnectionException noConnectionException) {
            wbConnection = null;
            LogMgr.logError(new CallerInfo(){}, "No connection returned for profile " + connectionProfile.getKey(), noConnectionException);
            string = ResourceMgr.getString("ErrNoConnReturned");
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            wbConnection = null;
            string = ResourceMgr.getString("ErrDrvClassVersion");
        }
        catch (ClassNotFoundException classNotFoundException) {
            wbConnection = null;
            string = ResourceMgr.getString("ErrDriverNotFound");
            string = StringUtil.replace(string, "%class%", connectionProfile.getDriverclass());
        }
        catch (SQLException sQLException) {
            wbConnection = null;
            charSequence = new StringBuilder(200);
            ((StringBuilder)charSequence).append(ExceptionUtil.getDisplay(sQLException));
            for (SQLException sQLException2 = sQLException.getNextException(); sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
                ((StringBuilder)charSequence).append("\n");
                ((StringBuilder)charSequence).append(ExceptionUtil.getDisplay(sQLException2));
            }
            string = ((StringBuilder)charSequence).toString();
            LogMgr.logError(new CallerInfo(){}, "SQL Exception when connecting", sQLException);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when connecting to the database", throwable);
            wbConnection = null;
            string = ExceptionUtil.getDisplay(throwable);
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this.parent);
        }
        try {
            this.closeConnectingInfo();
            object = wbConnection;
            charSequence = string;
            WbSwingUtilities.invoke(() -> this.lambda$doConnect$2((WbConnection)object, (String)charSequence));
            if (wbConnection == null && bl) {
                this.selectConnection();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error ending connection process", throwable);
        }
        finally {
            this.client.connectEnded();
            this.clearConnectIsInProgress();
        }
    }

    private void setConnectIsInProgress() {
        this.connectInProgress = true;
    }

    private void clearConnectIsInProgress() {
        this.connectInProgress = false;
    }

    @Override
    public void setStatusMessage(String string, int n) {
        this.setStatusMessage(string);
    }

    @Override
    public void setStatusMessage(String string) {
        WbSwingUtilities.invoke(() -> this.showPopupMessagePanel(string));
    }

    @Override
    public void clearStatusMessage() {
        this.showPopupMessagePanel("");
    }

    @Override
    public void doRepaint() {
        if (this.connectingInfo != null) {
            this.connectingInfo.forceRepaint();
        }
    }

    @Override
    public String getText() {
        if (this.connectingInfo == null) {
            return "";
        }
        return this.connectingInfo.getMessage();
    }

    private /* synthetic */ void lambda$doConnect$2(WbConnection wbConnection, String string) {
        if (wbConnection != null) {
            this.client.connected(wbConnection);
        } else {
            this.client.connectFailed(string);
        }
    }
}

