/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.interfaces.EncodingSelector;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.EncodingUtil;

public class EncodingDropDown
extends JPanel
implements EncodingSelector {
    protected JComboBox encodings = new JComboBox();
    private JLabel label;

    public EncodingDropDown() {
        this(Settings.getInstance().getDefaultFileEncoding(), true);
    }

    public EncodingDropDown(String string) {
        this(string, true);
    }

    public EncodingDropDown(String string, boolean bl) {
        int n;
        String[] stringArray = EncodingUtil.getEncodings();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        if (string != null && (n = defaultComboBoxModel.getIndexOf(string)) < 0) {
            defaultComboBoxModel.addElement(string);
        }
        this.encodings.setModel(defaultComboBoxModel);
        if (string != null) {
            this.setEncoding(string);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            this.label = new JLabel(ResourceMgr.getString("LblFileEncoding"));
            int n2 = this.encodings.getPreferredSize().height;
            int n3 = this.label.getPreferredSize().height;
            int n4 = (n2 - n3) / 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(n4, 0, 0, 0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.label, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.encodings, gridBagConstraints);
    }

    public void setLabelVisible(boolean bl) {
        if (this.label == null) {
            return;
        }
        this.label.setVisible(bl);
    }

    public boolean isLabelVisible() {
        if (this.label == null) {
            return false;
        }
        return this.label.isVisible();
    }

    @Override
    public void setEncoding(String string) {
        EventQueue.invokeLater(() -> {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.encodings.getModel();
            int n = defaultComboBoxModel.getIndexOf(string);
            if (n < 0) {
                this.encodings.addItem(string);
            }
            this.encodings.setSelectedItem(string);
        });
    }

    @Override
    public String getEncoding() {
        String string = (String)this.encodings.getSelectedItem();
        return string;
    }
}

