/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import workbench.db.exporter.ExportType;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.WbFile;

public class ExtensionFileFilter
extends FileFilter {
    private static Map<String, ExtensionFileFilter> FILTERS = new HashMap<String, ExtensionFileFilter>();
    private static FileFilter jarFileFilter;
    private final List<String> extensions;
    private final String desc;
    public static final String SQL_EXT = "sql";
    public static final String TXT_EXT = "txt";
    public static final String CSV_EXT = "csv";
    public static final String WORKSPACE_EXT = "wksp";
    public static final String XML_EXT = "xml";
    public static final String HTML_EXT = "html";
    public static final String XLS_EXT = "xls";
    public static final String XLSX_EXT = "xlsx";
    public static final String XLSXM_EXT = "xlsm";
    public static final String XLSM_EXT = "xml";
    public static final String ODS_EXT = "ods";
    public static final String JSON_EXT = "json";
    private boolean ignoreCase = true;
    private ExportType exportType;

    public ExtensionFileFilter(String string, List<String> list, boolean bl) {
        this.extensions = new ArrayList<String>(list);
        this.ignoreCase = bl;
        this.desc = string + this.getExtensionList();
    }

    public ExportType getExportType() {
        return this.exportType;
    }

    public boolean hasFilter(String string) {
        return this.extensions.contains(string);
    }

    public String getDefaultExtension() {
        return this.extensions.get(0);
    }

    public static String getExtension(File file) {
        return ExtensionFileFilter.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        WbFile wbFile = new WbFile(string);
        return wbFile.getExtension();
    }

    public static boolean hasSqlExtension(String string) {
        String string2 = ExtensionFileFilter.getExtension(string);
        return SQL_EXT.equalsIgnoreCase(string2);
    }

    public static boolean hasTxtExtension(String string) {
        String string2 = ExtensionFileFilter.getExtension(string);
        return TXT_EXT.equalsIgnoreCase(string2) || CSV_EXT.equalsIgnoreCase(string2);
    }

    public static boolean hasHtmlExtension(String string) {
        String string2 = ExtensionFileFilter.getExtension(string);
        return HTML_EXT.equalsIgnoreCase(string2);
    }

    public static boolean hasXmlExtension(String string) {
        String string2 = ExtensionFileFilter.getExtension(string);
        return "xml".equalsIgnoreCase(string2);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.extensions == null || this.extensions.isEmpty()) {
            return true;
        }
        String string = ExtensionFileFilter.getExtension(file);
        if (string == null) {
            return false;
        }
        if (this.extensions.contains(string)) {
            return true;
        }
        if (this.ignoreCase) {
            for (int i = 0; i < this.extensions.size(); ++i) {
                if (!string.equalsIgnoreCase(this.extensions.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static FileFilter getJarFileFilter() {
        if (jarFileFilter == null) {
            List<String> list = CollectionUtil.arrayList("jar", "zip");
            String string = ResourceMgr.getString("TxtArchivesFilterName");
            jarFileFilter = new ExtensionFileFilter(string, list, true);
        }
        return jarFileFilter;
    }

    public static FileFilter getSqlFileFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterSql", ExportType.SQL_INSERT, SQL_EXT);
    }

    public static FileFilter getSqlInsertDeleteFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterSqlInsDel", ExportType.SQL_DELETE_INSERT, SQL_EXT);
    }

    public static FileFilter getSqlUpdateFileFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterSqlInsDel", ExportType.SQL_UPDATE, SQL_EXT);
    }

    public static FileFilter getTextFileFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterText", ExportType.TEXT, TXT_EXT, CSV_EXT);
    }

    public static FileFilter getXmlFileFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterXml", ExportType.XML, "xml");
    }

    public static FileFilter getWorkspaceFileFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterWksp", null, WORKSPACE_EXT);
    }

    public static FileFilter getHtmlFileFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterHtml", ExportType.HTML, HTML_EXT);
    }

    public static FileFilter getXlsFileFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterXls", ExportType.XLS, XLS_EXT);
    }

    public static FileFilter getXlsXFileFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterXlsX", ExportType.XLSX, XLSX_EXT, XLSXM_EXT);
    }

    public static FileFilter getXlsMFileFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterXlsM", ExportType.XLSM, "xml");
    }

    public static FileFilter getOdsFileFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterOds", ExportType.ODS, ODS_EXT);
    }

    public static FileFilter getJsonFilterFilter() {
        return ExtensionFileFilter.getFileFilter("TxtFileFilterJson", ExportType.JSON, JSON_EXT);
    }

    private static ExtensionFileFilter getFileFilter(String string, ExportType exportType, String ... stringArray) {
        ExtensionFileFilter extensionFileFilter = FILTERS.get(string);
        if (extensionFileFilter == null) {
            String string2 = ResourceMgr.getString(string);
            extensionFileFilter = new ExtensionFileFilter(string2, Arrays.asList(stringArray), true);
            extensionFileFilter.exportType = exportType;
            FILTERS.put(string, extensionFileFilter);
        }
        return extensionFileFilter;
    }

    private String getExtensionList() {
        StringBuilder stringBuilder = new StringBuilder(this.extensions.size() * 5);
        stringBuilder.append(" (");
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("*.");
            stringBuilder.append(this.extensions.get(i));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getDescription() {
        return this.desc;
    }
}

