/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import workbench.gui.MainWindow;
import workbench.gui.components.EncodingDropDown;
import workbench.interfaces.EncodingSelector;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class FileEncodingAccessoryPanel
extends JPanel
implements EncodingSelector {
    private final EncodingDropDown encodingDropDown = new EncodingDropDown();
    private final JCheckBox autoDetectEncoding;
    private JCheckBox openInNewTab;

    public FileEncodingAccessoryPanel(MainWindow mainWindow) {
        super(new GridBagLayout());
        this.encodingDropDown.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.autoDetectEncoding = new JCheckBox(ResourceMgr.getString("LblDetectEncoding"));
        this.autoDetectEncoding.setSelected(GuiSettings.autoDetectFileEncoding());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        this.add((Component)this.autoDetectEncoding, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.encodingDropDown, gridBagConstraints);
        if (mainWindow != null) {
            this.openInNewTab = new JCheckBox(ResourceMgr.getString("LblOpenNewTab"));
            this.openInNewTab.setToolTipText(ResourceMgr.getDescription("LblOpenNewTab"));
            if (mainWindow.getCurrentSqlPanel() == null) {
                this.openInNewTab.setSelected(true);
                this.openInNewTab.setEnabled(false);
            } else {
                this.openInNewTab.setSelected(Settings.getInstance().getBoolProperty("workbench.file.newtab", false));
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.openInNewTab, gridBagConstraints);
        }
        this.encodingDropDown.setEncoding(Settings.getInstance().getDefaultFileEncoding());
    }

    @Override
    public String getEncoding() {
        return this.encodingDropDown.getEncoding();
    }

    @Override
    public void setEncoding(String string) {
        this.encodingDropDown.setEncoding(string);
    }

    public boolean openInNewTab() {
        if (this.openInNewTab == null) {
            return false;
        }
        return this.openInNewTab.isSelected();
    }

    public boolean getAutoDetect() {
        return this.autoDetectEncoding.isSelected();
    }
}

