/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbButton;
import workbench.resource.ResourceMgr;

public class FlatButton
extends WbButton {
    public static final Insets SMALL_MARGIN = new Insets(3, 5, 3, 5);
    public static final Insets LARGER_MARGIN = new Insets(5, 7, 5, 7);
    private boolean useDefaultMargin;
    private Insets customInsets;
    private String enableMsgKey;

    public FlatButton() {
        this.init();
    }

    public FlatButton(Action action) {
        super(action);
        this.init();
    }

    public FlatButton(Icon icon) {
        super(icon);
        this.init();
    }

    public FlatButton(String string) {
        super(string);
        this.init();
    }

    public void showMessageOnEnable(String string) {
        this.enableMsgKey = string;
    }

    private void init() {
        if (WbManager.getInstance() == null) {
            return;
        }
        if (WbManager.getInstance().isWindowsClassic()) {
            this.setFlatLook();
        }
    }

    public void setFlatLook() {
        this.setBorder(WbSwingUtilities.FLAT_BUTTON_BORDER);
    }

    public void setUseDefaultMargin(boolean bl) {
        this.useDefaultMargin = bl;
    }

    public void setCustomInsets(Insets insets) {
        this.customInsets = insets;
    }

    @Override
    public Insets getInsets() {
        if (this.useDefaultMargin) {
            return super.getInsets();
        }
        return this.customInsets == null ? SMALL_MARGIN : this.customInsets;
    }

    @Override
    public Insets getMargin() {
        if (this.useDefaultMargin) {
            return super.getMargin();
        }
        return this.customInsets == null ? SMALL_MARGIN : this.customInsets;
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (bl && !bl2 && this.enableMsgKey != null) {
            WbSwingUtilities.showToolTip(this, "<html><p style=\"margin:4px\">" + ResourceMgr.getString(this.enableMsgKey) + "</p></html>");
        }
    }
}

