/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;
import workbench.util.StringUtil;

public class MultiLineToolTipUI
extends BasicToolTipUI {
    private static final String[] EMPTY_LINES = new String[]{""};
    private Dimension prefSize = new Dimension();
    private String[] displayLines;
    private View view;
    private final Map renderingHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.renderingHints != null) {
            graphics2D.addRenderingHints(this.renderingHints);
        }
        Dimension dimension = jComponent.getSize();
        if (this.view != null) {
            Rectangle rectangle = new Rectangle(dimension);
            this.view.paint(graphics, rectangle);
        } else {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(jComponent.getForeground());
            if (this.displayLines != null) {
                int n = fontMetrics.getHeight();
                int n2 = this.displayLines.length;
                for (int i = 0; i < n2; ++i) {
                    graphics2D.drawString(this.displayLines[i], 3, n * (i + 1) - 2);
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        String string = ((JToolTip)jComponent).getTipText();
        this.view = null;
        if (string == null) {
            this.displayLines = EMPTY_LINES;
        } else if (string.startsWith("<html>")) {
            this.view = BasicHTML.createHTMLView(jComponent, string);
            this.prefSize = super.getPreferredSize(jComponent);
        } else {
            this.displayLines = StringUtil.PATTERN_CRLF.split(string);
            int n = -1;
            for (String string2 : this.displayLines) {
                int n2 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                n = n < n2 ? n2 : n;
            }
            int n3 = fontMetrics.getHeight() * this.displayLines.length;
            this.prefSize.setSize(n + 6, n3 + 2);
        }
        return this.prefSize;
    }
}

