/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.WbComboBox;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;

public class MultiSelectComboBox<T>
extends WbComboBox
implements PopupMenuListener {
    private static final String PROP_KEY = "userObject";
    private static final String ALL_ITEMS_SELECTED_DISPLAY = "*";
    private static final EmptyBorder EMPTY_BORDER = new EmptyBorder(1, 0, 1, 0);
    private int summaryIndex;
    private int selectAllIndex;
    private int selectNoneIndex;
    private int lastCustomIndex;
    private int valueIndexOffset;
    private List<JCheckBox> values = new ArrayList<JCheckBox>(0);
    private final Object dataLock = new Object();
    private String nothingSelectedText;
    private String selectAllLabel;
    private String selectNoneLabel;
    private ActionListener listener;
    private boolean selectionRequired;
    private boolean closing;
    private boolean closePopupOnSelect;
    private List<T> lastSelected;
    private int maxElementWidth;
    private final MultiSelectRenderer myRenderer = new MultiSelectRenderer();
    private final DividerBorder topDivider = new DividerBorder(4);

    public MultiSelectComboBox() {
        this.addPopupMenuListener(this);
        this.setRenderer(this.myRenderer);
        this.nothingSelectedText = ResourceMgr.getString("LblNone");
        this.selectAllLabel = ResourceMgr.getString("LblSelectAll");
        this.selectNoneLabel = ResourceMgr.getString("LblSelectNone");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItems(List<T> list, Collection<T> collection) {
        super.removeActionListener(this);
        this.removeAllItems();
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>(list.size());
        this.addItem(this.nothingSelectedText);
        this.addItem(this.selectAllLabel);
        this.addItem(this.selectNoneLabel);
        this.setupItemIndexes();
        this.maxElementWidth = Integer.MIN_VALUE;
        for (T t : list) {
            boolean bl = collection == null ? false : collection.contains(t);
            JCheckBox jCheckBox = new JCheckBox(t.toString());
            jCheckBox.setBorder(EMPTY_BORDER);
            int n = jCheckBox.getPreferredSize().width;
            if (n > this.maxElementWidth) {
                this.maxElementWidth = n;
            }
            jCheckBox.putClientProperty(PROP_KEY, t);
            jCheckBox.setSelected(bl);
            arrayList.add(jCheckBox);
            this.addItem(jCheckBox);
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.values = arrayList;
        }
        int n = UIManager.getInt("ScrollBar.width");
        this.setPopupWidth(this.maxElementWidth + n + 5);
        this.setMaximumRowCount(Math.min(this.getItemCount() + 1, 25));
        this.setToolTipText(this.getSelectedItemsDisplay());
        super.addActionListener(this);
    }

    public List<T> getItems() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = this.valueIndexOffset; i < this.getItemCount(); ++i) {
            Object e = this.getItemAt(i);
            if (!(e instanceof JCheckBox)) continue;
            JCheckBox jCheckBox = (JCheckBox)e;
            arrayList.add(jCheckBox.getClientProperty(PROP_KEY));
        }
        return arrayList;
    }

    public void setCloseOnSelect(boolean bl) {
        this.closePopupOnSelect = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllItems() {
        super.removeAllItems();
        Object object = this.dataLock;
        synchronized (object) {
            this.values.clear();
        }
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        if (actionListener == this.listener) {
            this.listener = null;
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValueCount() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.values.size();
        }
    }

    private void setupItemIndexes() {
        int n = this.getItemCount();
        this.lastCustomIndex = n - 1;
        this.valueIndexOffset = n;
        for (int i = 0; i < n; ++i) {
            Object e = this.getItemAt(i);
            if (e == this.nothingSelectedText) {
                this.summaryIndex = i;
                continue;
            }
            if (e == this.selectAllLabel) {
                this.selectAllIndex = i;
                continue;
            }
            if (e != this.selectNoneLabel) continue;
            this.selectNoneIndex = i;
        }
    }

    public void setSelectionRequired(boolean bl) {
        this.selectionRequired = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedItems(Collection<T> collection) {
        Object object = this.dataLock;
        synchronized (object) {
            Iterator<JCheckBox> iterator = this.values.iterator();
            while (iterator.hasNext()) {
                JCheckBox jCheckBox;
                T t = this.getUserObject(jCheckBox = iterator.next());
                jCheckBox.setSelected(t != null && collection.contains(t));
            }
        }
    }

    public T getSelectedItem() {
        List<T> list = this.getSelectedItems();
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedCount() {
        Object object = this.dataLock;
        synchronized (object) {
            int n = 0;
            for (JCheckBox jCheckBox : this.values) {
                if (!jCheckBox.isSelected()) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getSelectedItems() {
        ArrayList<T> arrayList = new ArrayList<T>();
        Object object = this.dataLock;
        synchronized (object) {
            for (JCheckBox jCheckBox : this.values) {
                if (!jCheckBox.isSelected()) continue;
                arrayList.add(this.getUserObject(jCheckBox));
            }
            return arrayList;
        }
    }

    private T getUserObject(JCheckBox jCheckBox) {
        return (T)jCheckBox.getClientProperty(PROP_KEY);
    }

    public void selectAll() {
        this.setSelectedForAll(true);
    }

    public void selectNone() {
        this.setSelectedForAll(false);
    }

    private void setSelectedForAll(boolean bl) {
        for (JCheckBox jCheckBox : this.values) {
            jCheckBox.setSelected(bl);
        }
    }

    private void fireActionPerformed(ActionEvent actionEvent) {
        if (this.listener != null) {
            this.listener.actionPerformed(actionEvent);
        }
    }

    private boolean isChanged() {
        List<T> list = this.getSelectedItems();
        return !Objects.equals(list, this.lastSelected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndFire() {
        boolean bl;
        boolean bl2 = this.isChanged();
        boolean bl3 = bl = !this.selectionRequired || this.getSelectedCount() > 0;
        if (!bl) {
            return;
        }
        try {
            this.closing = true;
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.getActionCommand(), 0);
            super.setPopupVisible(false);
            this.setToolTipText(this.getSelectedItemsDisplay());
            if (bl2) {
                this.fireActionPerformed(actionEvent);
            }
        }
        finally {
            this.closing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.getSelectedIndex();
        if (n == this.summaryIndex) {
            this.closeAndFire();
        } else if (n == this.selectAllIndex) {
            this.selectAll();
        } else if (n == this.selectNoneIndex) {
            this.selectNone();
        } else if (n >= this.valueIndexOffset) {
            Object object = this.dataLock;
            synchronized (object) {
                JCheckBox jCheckBox = this.values.get(n - this.valueIndexOffset);
                jCheckBox.setSelected(!jCheckBox.isSelected());
            }
        }
        this.setSelectedIndex(-1);
        if (this.closePopupOnSelect && this.listener != null) {
            this.closeAndFire();
        }
    }

    public String getSelectedItemsDisplay() {
        List<T> list = this.getSelectedItems();
        if (list.size() == this.getValueCount()) {
            return ALL_ITEMS_SELECTED_DISPLAY;
        }
        if (list.isEmpty()) {
            return this.nothingSelectedText;
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 10);
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(list.get(i).toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public void hidePopup() {
    }

    @Override
    public void setPopupVisible(boolean bl) {
        if (bl) {
            super.setPopupVisible(bl);
        }
    }

    public Object getPrototypeDisplayValue() {
        return this.getSelectedItemsDisplay();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.lastSelected = this.getSelectedItems();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (this.closing) {
            return;
        }
        EventQueue.invokeLater(this::closeAndFire);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    private class MultiSelectRenderer
    extends DefaultListCellRenderer {
        private ImageIcon icon = IconMgr.getInstance().getLabelIcon("filter_go");
        private Dimension iconSize;

        MultiSelectRenderer() {
            int n = this.icon.getIconWidth();
            int n2 = this.icon.getIconHeight();
            this.iconSize = new Dimension((int)((double)n * 1.5), (int)((double)n2 * 1.5));
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (n > MultiSelectComboBox.this.lastCustomIndex) {
                JCheckBox jCheckBox = (JCheckBox)MultiSelectComboBox.this.values.get(n - MultiSelectComboBox.this.valueIndexOffset);
                jCheckBox.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
                jCheckBox.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                return jCheckBox;
            }
            if (n == MultiSelectComboBox.this.selectAllIndex) {
                JComponent jComponent = (JComponent)super.getListCellRendererComponent((JList<?>)jList, MultiSelectComboBox.this.selectAllLabel, n, bl, bl2);
                jComponent.setBorder(MultiSelectComboBox.this.topDivider);
                jComponent.setToolTipText(null);
                return jComponent;
            }
            if (n == MultiSelectComboBox.this.selectNoneIndex) {
                JComponent jComponent = (JComponent)super.getListCellRendererComponent((JList<?>)jList, MultiSelectComboBox.this.selectNoneLabel, n, bl, bl2);
                jComponent.setBorder(DividerBorder.BOTTOM_DIVIDER);
                jComponent.setToolTipText(null);
                return jComponent;
            }
            if (n == MultiSelectComboBox.this.summaryIndex) {
                JComponent jComponent = (JComponent)super.getListCellRendererComponent((JList<?>)jList, MultiSelectComboBox.this.getSelectedItemsDisplay(), n, bl, bl2);
                jComponent.setPreferredSize(this.iconSize);
                jComponent.setToolTipText(ResourceMgr.getDescription("LblMultiClose"));
                try {
                    JLabel jLabel = (JLabel)jComponent;
                    jLabel.setIcon(this.icon);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return jComponent;
            }
            int n2 = MultiSelectComboBox.this.getSelectedCount();
            ComboBoxEditor comboBoxEditor = MultiSelectComboBox.this.getEditor();
            if (n2 == 0) {
                comboBoxEditor.setItem(MultiSelectComboBox.this.nothingSelectedText);
            } else if (n2 == MultiSelectComboBox.this.getValueCount()) {
                comboBoxEditor.setItem(MultiSelectComboBox.ALL_ITEMS_SELECTED_DISPLAY);
            } else {
                comboBoxEditor.setItem(MultiSelectComboBox.this.getSelectedItemsDisplay());
            }
            return comboBoxEditor.getEditorComponent();
        }
    }
}

