/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.HistoryTextField;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.ValidatingDialog;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class SearchCriteriaPanel
extends JPanel
implements ValidatingComponent,
ActionListener {
    private String caseProperty;
    private String wordProperty;
    private String regexProperty;
    private String highlightProperty;
    private String baseProperty;
    private String wrapProperty;
    private JCheckBox ignoreCase;
    private JCheckBox wholeWord;
    private JCheckBox useRegEx;
    private JCheckBox highlightAll;
    private JCheckBox wrapSearch;
    protected HistoryTextField criteria;
    protected JLabel label;

    public SearchCriteriaPanel() {
        this((String)null);
    }

    public SearchCriteriaPanel(String string) {
        this(string, "workbench.sql", false);
    }

    public SearchCriteriaPanel(String string, String string2, boolean bl) {
        this.baseProperty = string2;
        this.caseProperty = string2 + ".search.ignoreCase";
        this.wordProperty = string2 + ".search.wholeWord";
        this.regexProperty = string2 + ".search.useRegEx";
        this.wrapProperty = string2 + ".search.wrapSearch";
        if (bl) {
            this.highlightProperty = string2 + ".highlight";
        }
        this.ignoreCase = new JCheckBox(ResourceMgr.getString("LblSearchIgnoreCase"));
        this.ignoreCase.setName("ignorecase");
        this.ignoreCase.setToolTipText(ResourceMgr.getDescription("LblSearchIgnoreCase"));
        this.ignoreCase.setSelected(Settings.getInstance().getBoolProperty(this.caseProperty, true));
        this.wholeWord = new JCheckBox(ResourceMgr.getString("LblSearchWordsOnly"));
        this.wholeWord.setToolTipText(ResourceMgr.getDescription("LblSearchWordsOnly"));
        this.wholeWord.setSelected(Settings.getInstance().getBoolProperty(this.wordProperty, false));
        this.wholeWord.setName("wholeword");
        this.useRegEx = new JCheckBox(ResourceMgr.getString("LblSearchRegEx"));
        this.useRegEx.setToolTipText(ResourceMgr.getDescription("LblSearchRegEx"));
        this.useRegEx.setSelected(Settings.getInstance().getBoolProperty(this.regexProperty, false));
        this.useRegEx.setName("regex");
        this.wrapSearch = new JCheckBox(ResourceMgr.getString("LblSearchWrap"));
        this.wrapSearch.setToolTipText(ResourceMgr.getDescription("LblSearchWrap"));
        this.wrapSearch.setSelected(Settings.getInstance().getBoolProperty(this.wrapProperty, false));
        this.wrapSearch.setName("wrap");
        if (bl) {
            this.highlightAll = new JCheckBox(ResourceMgr.getString("LblHiliteAll"));
            this.highlightAll.setToolTipText(ResourceMgr.getDescription("LblHiliteAll"));
            this.highlightAll.setSelected(Settings.getInstance().getBoolProperty(this.highlightProperty, false));
        }
        this.label = new JLabel(ResourceMgr.getString("LblSearchCriteria"));
        this.criteria = new HistoryTextField(".search");
        this.criteria.setName("searchtext");
        this.criteria.restoreSettings(Settings.getInstance(), this.baseProperty);
        if (string != null) {
            this.criteria.setText(string);
        }
        this.criteria.selectAll();
        this.criteria.setColumns(40);
        this.criteria.addMouseListener(new TextComponentMouseListener());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.label, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.criteria, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.ignoreCase, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.wrapSearch, gridBagConstraints);
        if (bl) {
            ++gridBagConstraints.gridy;
            this.add((Component)this.highlightAll, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        this.add((Component)this.wholeWord, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.useRegEx, gridBagConstraints);
    }

    public String getCriteria() {
        return this.criteria.getText();
    }

    public boolean getWholeWordOnly() {
        return this.wholeWord.isSelected();
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase.isSelected();
    }

    public boolean getUseRegex() {
        return this.useRegEx.isSelected();
    }

    public boolean getWrapSearch() {
        return this.wrapSearch.isSelected();
    }

    public boolean getHighlightAll() {
        if (this.highlightAll == null) {
            return false;
        }
        return this.highlightAll.isSelected();
    }

    public void setSearchCriteria(String string) {
        this.criteria.setText(string);
        if (string != null) {
            this.criteria.selectAll();
        }
    }

    public boolean showFindDialog(Component component) {
        return this.showFindDialog(component, ResourceMgr.getString("TxtWindowTitleSearchText"));
    }

    public boolean showFindDialog(Component component, String string) {
        Window window = WbSwingUtilities.getWindowAncestor(component);
        final ValidatingDialog validatingDialog = ValidatingDialog.createDialog(window, this, string, component, 0, false);
        this.criteria.addActionListener(new ActionListener(){
            private String lastCmd;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("comboBoxEdited") && !"comboBoxChanged".equals(this.lastCmd)) {
                    validatingDialog.approveAndClose();
                }
                this.lastCmd = actionEvent.getActionCommand();
            }
        });
        validatingDialog.setVisible(true);
        boolean bl = !validatingDialog.isCancelled();
        this.criteria.addToHistory(this.criteria.getText());
        this.criteria.saveSettings(Settings.getInstance(), this.baseProperty);
        Settings.getInstance().setProperty(this.caseProperty, this.getIgnoreCase());
        Settings.getInstance().setProperty(this.wordProperty, this.getWholeWordOnly());
        Settings.getInstance().setProperty(this.regexProperty, this.getUseRegex());
        Settings.getInstance().setProperty(this.wrapProperty, this.getWrapSearch());
        if (this.highlightProperty != null) {
            Settings.getInstance().setProperty(this.highlightProperty, this.getHighlightAll());
        }
        return bl;
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public void componentDisplayed() {
        this.criteria.requestFocusInWindow();
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

