/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import javax.swing.Icon;
import workbench.gui.renderer.ColorUtils;
import workbench.resource.Settings;

public class SortArrowIcon
implements Icon {
    private final Direction direction;
    private final int width;
    private final int height;
    private static final HashMap<Integer, SortArrowIcon> sharedUpArrows = new HashMap(2);
    private static final HashMap<Integer, SortArrowIcon> sharedDownArrows = new HashMap(2);
    private final int blendValue;

    public static synchronized SortArrowIcon getIcon(Direction direction, int n) {
        Integer n2;
        HashMap<Integer, SortArrowIcon> hashMap = direction == Direction.UP ? sharedUpArrows : sharedDownArrows;
        SortArrowIcon sortArrowIcon = hashMap.get(n2 = Integer.valueOf(n));
        if (sortArrowIcon == null) {
            sortArrowIcon = new SortArrowIcon(direction, n);
            hashMap.put(n2, sortArrowIcon);
        }
        return sortArrowIcon;
    }

    private SortArrowIcon(Direction direction, int n) {
        this.direction = direction;
        this.width = (int)((double)n * 1.1);
        this.height = n;
        this.blendValue = Settings.getInstance().getIntProperty("workbench.gui.sorticon.blend", 128);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color = component.getBackground();
        Color color2 = component.getForeground();
        Color color3 = ColorUtils.blend(color, Color.BLACK, this.blendValue);
        int n3 = this.width;
        int n4 = this.height;
        int n5 = n2 + n4;
        int n6 = n2;
        int[] nArray = new int[]{n, n + n3 / 2, n + n3};
        int[] nArray2 = this.direction == Direction.UP ? new int[]{n5 - 1, n6 - 1, n5 - 1} : new int[]{n6, n5, n6};
        graphics.setColor(color3);
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(color2);
    }

    public static enum Direction {
        UP,
        DOWN;

    }
}

