/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.util.LinkedList;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedPaneHistory
implements ChangeListener {
    private JTabbedPane client;
    private LinkedList<Component> history = new LinkedList();

    public TabbedPaneHistory(JTabbedPane jTabbedPane) {
        this.client = jTabbedPane;
        this.client.addChangeListener(this);
    }

    public void clear() {
        this.history.clear();
    }

    private void addComponent(Component component) {
        if (this.history.contains(component)) {
            this.history.remove(component);
        }
        this.history.addFirst(component);
    }

    public void restoreLastTab() {
        Component component = this.getLastUsedComponent();
        if (component == null) {
            return;
        }
        this.history.removeFirst();
        try {
            this.client.setSelectedComponent(component);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.history.remove(component);
        }
    }

    private Component getLastUsedComponent() {
        if (this.history.size() == 0) {
            return null;
        }
        if (this.history.size() == 1) {
            return this.history.get(0);
        }
        return this.history.get(1);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() != this.client) {
            return;
        }
        this.addComponent(this.client.getSelectedComponent());
    }
}

