/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import javax.swing.JTabbedPane;

public class TabbedPaneTraversalPolicy
extends FocusTraversalPolicy {
    private JTabbedPane tabPane;

    public TabbedPaneTraversalPolicy(JTabbedPane jTabbedPane) {
        this.tabPane = jTabbedPane;
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        if (container != this.tabPane) {
            return null;
        }
        int n = this.tabPane.indexOfComponent(component) + 1;
        if (n >= this.tabPane.getTabCount()) {
            n = 0;
        }
        return this.tabPane.getComponentAt(n);
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        if (container != this.tabPane) {
            return null;
        }
        int n = this.tabPane.indexOfComponent(component) - 1;
        if (n < 0) {
            n = this.tabPane.getTabCount() - 1;
        }
        return this.tabPane.getComponentAt(n);
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.tabPane.getComponentAt(0);
    }

    @Override
    public Component getFirstComponent(Container container) {
        return this.tabPane.getComponentAt(0);
    }

    @Override
    public Component getLastComponent(Container container) {
        return this.tabPane.getComponentAt(this.tabPane.getTabCount() - 1);
    }
}

