/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class TextFieldWidthAdjuster {
    public void adjustAllFields(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        if (componentArray == null) {
            return;
        }
        for (Component component : componentArray) {
            if (!(component instanceof JTextField)) continue;
            this.adjustField((JTextField)component);
        }
    }

    public void adjustField(JTextField jTextField) {
        FontMetrics fontMetrics;
        Font font = jTextField.getFont();
        if (font != null && (fontMetrics = jTextField.getFontMetrics(font)) != null) {
            int n = fontMetrics.charWidth('M');
            Dimension dimension = jTextField.getPreferredSize();
            int n2 = 0;
            n2 = dimension != null ? (int)dimension.getHeight() : fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
            int n3 = jTextField.getColumns();
            Dimension dimension2 = new Dimension(n * n3 + 1, n2);
            jTextField.setMinimumSize(dimension2);
        }
    }
}

