/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicButtonUI;
import workbench.resource.ResourceMgr;

public class WbButton
extends JButton
implements MouseListener {
    private static final Border ICON_EMPTY_BORDER = new EmptyBorder(1, 0, 0, 0);
    private static final Border SMALL_EMPTY_BORDER = new EmptyBorder(2, 2, 2, 2);
    private static final Border LARGE_EMPTY_BORDER = new EmptyBorder(5, 5, 5, 5);
    private Border rolloverBorder;
    private Border emptyBorder;
    protected boolean iconButton;
    private boolean rolloverEnabled;

    public WbButton() {
        this.init();
    }

    public WbButton(Action action) {
        super(action);
        this.init();
    }

    public WbButton(String string) {
        super(string);
        this.init();
    }

    public WbButton(Icon icon) {
        super(icon);
        this.iconButton = true;
        this.init();
    }

    private void init() {
        this.putClientProperty("jgoodies.isNarrow", Boolean.FALSE);
        this.setRolloverEnabled(true);
    }

    public void setResourceKey(String string) {
        this.setText(ResourceMgr.getString(string));
        this.setToolTipText(ResourceMgr.getDescription(string));
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            super.setText(null);
            return;
        }
        int n = string.indexOf(38);
        if (n > -1) {
            char c = string.charAt(n + 1);
            string = string.substring(0, n) + string.substring(n + 1);
            this.setMnemonic((int)c);
        }
        super.setText(string);
    }

    public void setBasicUI() {
        this.setUI(new BasicButtonUI());
    }

    public void disableBasicRollover() {
        this.removeMouseListener(this);
        this.rolloverEnabled = false;
    }

    public void enableBasicRollover() {
        if (this.rolloverEnabled) {
            return;
        }
        this.setBasicUI();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        BasicBorders.RolloverButtonBorder rolloverButtonBorder = new BasicBorders.RolloverButtonBorder(uIDefaults.getColor("controlShadow"), uIDefaults.getColor("controlDkShadow"), uIDefaults.getColor("controlHighlight"), uIDefaults.getColor("controlLtHighlight"));
        if (this.iconButton) {
            this.rolloverBorder = new CompoundBorder(rolloverButtonBorder, ICON_EMPTY_BORDER);
            this.emptyBorder = SMALL_EMPTY_BORDER;
        } else {
            this.rolloverBorder = new CompoundBorder(rolloverButtonBorder, SMALL_EMPTY_BORDER);
            this.emptyBorder = LARGE_EMPTY_BORDER;
        }
        this.setBorderPainted(true);
        this.setBorder(this.emptyBorder);
        this.addMouseListener(this);
        this.rolloverEnabled = true;
    }

    public void enableToolbarRollover() {
        this.rolloverBorder = null;
        this.emptyBorder = null;
        this.setBorderPainted(false);
        this.setRolloverEnabled(false);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.rolloverBorder == null) {
            this.setBorderPainted(true);
        } else {
            this.setBorder(this.rolloverBorder);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.rolloverBorder == null) {
            this.setBorderPainted(false);
        } else {
            this.setBorder(this.emptyBorder);
        }
    }
}

