/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FileEncodingAccessoryPanel;
import workbench.interfaces.EncodingSelector;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class WbFileChooser
extends JFileChooser
implements PropertyChangeListener {
    private String windowSettingsId;
    private JDialog dialog;
    private FileEncodingAccessoryPanel encodingPanel;
    private EncodingSelector encodingSelector;

    public WbFileChooser() {
        this.init();
    }

    public WbFileChooser(File file) {
        super(file);
        this.init();
    }

    public WbFileChooser(String string) {
        super(string);
        this.init();
    }

    private void init() {
        this.addPropertyChangeListener(this);
        this.putClientProperty("FileChooser.useShellFolder", GuiSettings.getUseShellFolders());
    }

    public void setSettingsID(String string) {
        this.windowSettingsId = string;
    }

    public JDialog getCurrentDialog() {
        return this.dialog;
    }

    public void setEncodingSelector(EncodingSelector encodingSelector) {
        this.encodingSelector = encodingSelector;
    }

    public void addEncodingPanel(FileEncodingAccessoryPanel fileEncodingAccessoryPanel) {
        this.encodingPanel = fileEncodingAccessoryPanel;
        this.encodingSelector = fileEncodingAccessoryPanel;
        super.setAccessory(fileEncodingAccessoryPanel);
    }

    @Override
    public JDialog createDialog(Component component) throws HeadlessException {
        this.dialog = super.createDialog(component);
        ResourceMgr.setWindowIcons((Window)this.dialog, "workbench");
        if (Settings.getInstance().restoreWindowSize(this.dialog, this.windowSettingsId)) {
            this.dialog.setLocationRelativeTo(component);
        }
        return this.dialog;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("JFileChooserDialogIsClosingProperty") && this.windowSettingsId != null) {
            try {
                JDialog jDialog = (JDialog)propertyChangeEvent.getOldValue();
                Settings.getInstance().storeWindowSize(jDialog, this.windowSettingsId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.encodingPanel != null && this.encodingPanel.getAutoDetect() && this.isSelectionChange(propertyChangeEvent.getPropertyName())) {
            this.updateEncoding();
        }
    }

    private boolean isSelectionChange(String string) {
        return string.equals("SelectedFileChangedProperty") || string.equals("SelectedFilesChangedProperty");
    }

    private void updateEncoding() {
        List<String> list = this.getFileEncodings();
        if (list.isEmpty()) {
            this.encodingPanel.setEncoding(Settings.getInstance().getDefaultFileEncoding());
        } else if (list.size() == 1) {
            this.encodingPanel.setEncoding(list.get(0));
        } else {
            this.encodingPanel.setEncoding("");
        }
    }

    public boolean validateInput() {
        JComponent jComponent = this.getAccessory();
        if (jComponent instanceof ValidatingComponent) {
            ValidatingComponent validatingComponent = (ValidatingComponent)((Object)jComponent);
            return validatingComponent.validateInput();
        }
        if (this.isFileSelectionEnabled()) {
            return this.encodingMatches();
        }
        File file = this.getSelectedFile();
        String string = null;
        if (!file.isDirectory()) {
            string = "ErrExportOutputDirNotDir";
        }
        if (!file.exists()) {
            string = "ErrOutputDirNotFound";
        }
        if (string != null) {
            String string2 = ResourceMgr.getFormattedString(string, file.getAbsolutePath());
            WbSwingUtilities.showErrorMessage(this.dialog, string2);
            return false;
        }
        return true;
    }

    private List<String> getFileEncodings() {
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        File[] fileArray = null;
        if (this.isMultiSelectionEnabled()) {
            fileArray = this.getSelectedFiles();
        } else {
            File[] fileArray2 = this.getSelectedFile();
            if (fileArray2 != null) {
                fileArray = new File[]{fileArray2};
            }
        }
        if (fileArray == null || fileArray.length == 0) {
            return Collections.emptyList();
        }
        for (File file : fileArray) {
            String string = FileUtil.detectFileEncoding(file);
            if (string == null) continue;
            set.add(string);
        }
        return new ArrayList<String>(set);
    }

    private boolean encodingMatches() {
        if (this.encodingSelector == null) {
            return true;
        }
        String string = this.encodingSelector.getEncoding();
        File[] fileArray = this.getSelectedFiles();
        if (fileArray == null || fileArray.length == 0) {
            return true;
        }
        List<String> list = this.getFileEncodings();
        if (CollectionUtil.isEmpty(list)) {
            return true;
        }
        if (list.size() != 1) {
            WbSwingUtilities.showErrorMessage(ResourceMgr.getString("MsgEncodingsMismatch"));
            return false;
        }
        if (!StringUtil.equalStringIgnoreCase(list.get(0), string)) {
            String string2 = ResourceMgr.getFormattedString("MsgEncodingWrong", string, list.get(0));
            return WbSwingUtilities.getYesNo(this, string2);
        }
        return true;
    }

    @Override
    public void approveSelection() {
        if (this.validateInput()) {
            super.approveSelection();
        }
    }
}

